/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.snapshot;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.spi.OffsetState;
import io.debezium.connector.postgresql.spi.SlotState;
import io.debezium.connector.postgresql.spi.Snapshotter;
import io.debezium.relational.TableId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class QueryingSnapshotter
implements Snapshotter {
    private PostgresConnectorConfig config;
    private Map<TableId, String> snapshotOverrides;

    @Override
    public void init(PostgresConnectorConfig config, OffsetState sourceInfo, SlotState slotState) {
        this.config = config;
        this.snapshotOverrides = this.getSnapshotSelectOverridesByTable();
    }

    @Override
    public Optional<String> buildSnapshotQuery(TableId tableId) {
        if (this.snapshotOverrides.containsKey(tableId)) {
            return Optional.of(this.snapshotOverrides.get(tableId));
        }
        StringBuilder q = new StringBuilder();
        q.append("SELECT * FROM ");
        q.append(tableId.toDoubleQuotedString());
        return Optional.of(q.toString());
    }

    private Map<TableId, String> getSnapshotSelectOverridesByTable() {
        String tableList = this.config.snapshotSelectOverrides();
        if (tableList == null) {
            return Collections.emptyMap();
        }
        HashMap<TableId, String> snapshotSelectOverridesByTable = new HashMap<TableId, String>();
        for (String table : tableList.split(",")) {
            snapshotSelectOverridesByTable.put(TableId.parse(table), this.config.snapshotSelectOverrideForTable(table));
        }
        return snapshotSelectOverridesByTable;
    }
}

