/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.Module;
import java.time.Instant;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

@NotThreadSafe
public class SourceInfo
extends AbstractSourceInfo {
    public static final String SERVER_NAME_KEY = "name";
    public static final String LOG_TIMESTAMP_KEY = "ts_ms";
    public static final String CHANGE_LSN_KEY = "change_lsn";
    public static final String COMMIT_LSN_KEY = "commit_lsn";
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final Schema SCHEMA = SourceInfo.schemaBuilder().name("io.debezium.connector.sqlserver.Source").field("name", Schema.STRING_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("change_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("commit_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("snapshot", Schema.OPTIONAL_BOOLEAN_SCHEMA).build();
    private final String serverName;
    private Lsn changeLsn;
    private Lsn commitLsn;
    private boolean snapshot;
    private Instant sourceTime;

    protected SourceInfo(String serverName) {
        super(Module.version());
        this.serverName = serverName;
    }

    public void setChangeLsn(Lsn lsn) {
        this.changeLsn = lsn;
    }

    public Lsn getChangeLsn() {
        return this.changeLsn;
    }

    public Lsn getCommitLsn() {
        return this.commitLsn;
    }

    public void setCommitLsn(Lsn commitLsn) {
        this.commitLsn = commitLsn;
    }

    public void setSourceTime(Instant instant) {
        this.sourceTime = instant;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    protected Schema schema() {
        return SCHEMA;
    }

    @Override
    protected String connector() {
        return Module.name();
    }

    @Override
    public Struct struct() {
        Struct ret = super.struct().put(SERVER_NAME_KEY, (Object)this.serverName).put(LOG_TIMESTAMP_KEY, this.sourceTime == null ? null : Long.valueOf(this.sourceTime.toEpochMilli())).put(SNAPSHOT_KEY, (Object)this.snapshot);
        if (this.changeLsn != null && this.changeLsn.isAvailable()) {
            ret.put(CHANGE_LSN_KEY, (Object)this.changeLsn.toString());
        }
        if (this.commitLsn != null && this.commitLsn.isAvailable()) {
            ret.put(COMMIT_LSN_KEY, (Object)this.commitLsn.toString());
        }
        return ret;
    }

    public String toString() {
        return "SourceInfo [serverName=" + this.serverName + ", changeLsn=" + this.changeLsn + ", commitLsn=" + this.commitLsn + ", snapshot=" + this.snapshot + ", sourceTime=" + this.sourceTime + "]";
    }
}

