/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SourceInfo;
import io.debezium.connector.sqlserver.TxLogPosition;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class SqlServerOffsetContext
implements OffsetContext {
    private static final String SERVER_PARTITION_KEY = "server";
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private final Schema sourceInfoSchema;
    private final SourceInfo sourceInfo;
    private final Map<String, String> partition;
    private boolean snapshotCompleted;

    public SqlServerOffsetContext(String serverName, TxLogPosition position, boolean snapshot, boolean snapshotCompleted) {
        this.partition = Collections.singletonMap(SERVER_PARTITION_KEY, serverName);
        this.sourceInfo = new SourceInfo(serverName);
        this.sourceInfo.setCommitLsn(position.getCommitLsn());
        this.sourceInfo.setChangeLsn(position.getInTxLsn());
        this.sourceInfoSchema = this.sourceInfo.schema();
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            this.sourceInfo.setSnapshot(snapshot);
        }
    }

    @Override
    public Map<String, ?> getPartition() {
        return this.partition;
    }

    @Override
    public Map<String, ?> getOffset() {
        if (this.sourceInfo.isSnapshot()) {
            return Collect.hashMapOf("snapshot", true, SNAPSHOT_COMPLETED_KEY, this.snapshotCompleted, "commit_lsn", this.sourceInfo.getCommitLsn().toString());
        }
        return Collect.hashMapOf("commit_lsn", this.sourceInfo.getCommitLsn().toString(), "change_lsn", this.sourceInfo.getChangeLsn() == null ? null : this.sourceInfo.getChangeLsn().toString());
    }

    @Override
    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    @Override
    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public TxLogPosition getChangePosition() {
        return TxLogPosition.valueOf(this.sourceInfo.getCommitLsn(), this.sourceInfo.getChangeLsn());
    }

    public void setChangePosition(TxLogPosition position) {
        this.sourceInfo.setCommitLsn(position.getCommitLsn());
        this.sourceInfo.setChangeLsn(position.getInTxLsn());
    }

    public void setSourceTime(Instant instant) {
        this.sourceInfo.setSourceTime(instant);
    }

    @Override
    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && !this.snapshotCompleted;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    @Override
    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(true);
        this.snapshotCompleted = false;
    }

    @Override
    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    @Override
    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(false);
    }

    public String toString() {
        return "SqlServerOffsetContext [sourceInfoSchema=" + this.sourceInfoSchema + ", sourceInfo=" + this.sourceInfo + ", partition=" + this.partition + ", snapshotCompleted=" + this.snapshotCompleted + "]";
    }

    public static class Loader
    implements OffsetContext.Loader {
        private final String logicalName;

        public Loader(String logicalName) {
            this.logicalName = logicalName;
        }

        @Override
        public Map<String, ?> getPartition() {
            return Collections.singletonMap(SqlServerOffsetContext.SERVER_PARTITION_KEY, this.logicalName);
        }

        @Override
        public OffsetContext load(Map<String, ?> offset) {
            Lsn changeLsn = Lsn.valueOf((String)offset.get("change_lsn"));
            Lsn commitLsn = Lsn.valueOf((String)offset.get("commit_lsn"));
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(SqlServerOffsetContext.SNAPSHOT_COMPLETED_KEY));
            return new SqlServerOffsetContext(this.logicalName, TxLogPosition.valueOf(commitLsn, changeLsn), snapshot, snapshotCompleted);
        }
    }
}

