/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source;

import io.debezium.embedded.EmbeddedEngine;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.cdc.source.listening.CDCSourceObjectKeeper;
import io.siddhi.extension.io.cdc.source.listening.ChangeDataCapture;
import io.siddhi.extension.io.cdc.source.listening.WrongConfigurationException;
import io.siddhi.extension.io.cdc.source.polling.CDCPoller;
import io.siddhi.extension.io.cdc.util.CDCSourceUtil;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

@Extension(name="cdc", namespace="source", description="The CDC source receives events when change events (i.e., INSERT, UPDATE, DELETE) are triggered for a database table. Events are received in the 'key-value' format.\nThe key values of the map of a CDC change event are as follows.\n\tFor insert: Keys are specified as columns of the table.\n\tFor delete: Keys are followed followed by the specified table columns. This is achieved via 'before_'. e.g., specifying 'before_X' results in the key being added before the column named 'X'.\n\tFor update: Keys are followed followed by the specified table columns. This is achieved via 'before_'. e.g., specifying 'before_X' results in the key being added before the column named 'X'.\nFor 'polling' mode: Keys are specified as the coloumns of the table.\nSee parameter: mode for supported databases and change events.", parameters={@Parameter(name="url", description="The connection URL to the database.\nF=The format used is: 'jdbc:mysql://<host>:<port>/<database_name>' ", type={DataType.STRING}), @Parameter(name="mode", description="Mode to capture the change data. The type of events that can be received, and the required parameters differ based on the mode. The mode can be one of the following:\n'polling': This mode uses a column named 'polling.column' to monitor the given table. It captures change events of the 'RDBMS', 'INSERT, and 'UPDATE' types.\n'listening': This mode uses logs to monitor the given table. It currently supports change events only of the 'MySQL', 'INSERT', 'UPDATE', and 'DELETE' types.", type={DataType.STRING}, defaultValue="listening", optional=true), @Parameter(name="jdbc.driver.name", description="The driver class name for connecting the database. **It is required to specify a value for this parameter when the mode is 'polling'.**", type={DataType.STRING}, defaultValue="<Empty_String>", optional=true), @Parameter(name="username", description="The username to be used for accessing the database. This user needs to have the 'SELECT', 'RELOAD', 'SHOW DATABASES', 'REPLICATION SLAVE', and 'REPLICATION CLIENT'privileges for the change data capturing table (specified via the 'table.name' parameter).\nTo operate in the polling mode, the user needs 'SELECT' privileges.", type={DataType.STRING}), @Parameter(name="password", description="The password of the username you specified for accessing the database.", type={DataType.STRING}), @Parameter(name="pool.properties", description="The pool parameters for the database connection can be specified as key-value pairs.", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>"), @Parameter(name="datasource.name", description="Name of the wso2 datasource to connect to the database. When datasource name is provided, the URL, username and password are not needed. A datasource based connection is given more priority over the URL based connection.\n This parameter is applicable only when the mode is set to 'polling', and it can be applied only when you use this extension with WSO2 Stream Processor.", type={DataType.STRING}, defaultValue="<Empty_String>", optional=true), @Parameter(name="table.name", description="The name of the table that needs to be monitored for data changes.", type={DataType.STRING}), @Parameter(name="polling.column", description="The column name  that is polled to capture the change data. It is recommended to have a TIMESTAMP field as the 'polling.column' in order to capture the inserts and updates.\nNumeric auto-incremental fields and char fields can also be used as 'polling.column'. However, note that fields of these types only support insert change capturing, and the possibility of using a char field also depends on how the data is input.\n**It is required to enter a value for this parameter when the mode is 'polling'.**", type={DataType.STRING}, defaultValue="<Empty_String>", optional=true), @Parameter(name="polling.interval", description="The time interval (specified in seconds) to poll the given table for changes.\nThis parameter is applicable only when the mode is set to 'polling'.", type={DataType.INT}, defaultValue="1", optional=true), @Parameter(name="operation", description="The change event operation you want to carry out. Possible values are 'insert', 'update' or 'delete'. It is required to specify a value when the mode is 'listening'.\nThis parameter is not case sensitive.", type={DataType.STRING}), @Parameter(name="connector.properties", description="Here, you can specify Debezium connector properties as a comma-separated string. \nThe properties specified here are given more priority over the parameters. This parameter is applicable only for the 'listening' mode.", type={DataType.STRING}, optional=true, defaultValue="Empty_String"), @Parameter(name="database.server.id", description="An ID to be used when joining MySQL database cluster to read the bin log. This should be a unique integer between 1 to 2^32. This parameter is applicable only when the mode is 'listening'.", type={DataType.STRING}, optional=true, defaultValue="Random integer between 5400 and 6400"), @Parameter(name="database.server.name", description="A logical name that identifies and provides a namespace for the database server. This parameter is applicable only when the mode is 'listening'.", defaultValue="{host}_{port}", optional=true, type={DataType.STRING})}, examples={@Example(syntax="@source(type = 'cdc' , url = 'jdbc:mysql://localhost:3306/SimpleDB', \nusername = 'cdcuser', password = 'pswd4cdc', \ntable.name = 'students', operation = 'insert', \n@map(type='keyvalue', @attributes(id = 'id', name = 'name')))\ndefine stream inputStream (id string, name string);", description="In this example, the CDC source listens to the row insertions that are made in the 'students' table with the column name, and the ID. This table belongs to the 'SimpleDB' MySQL database that can be accessed via the given URL."), @Example(syntax="@source(type = 'cdc' , url = 'jdbc:mysql://localhost:3306/SimpleDB', \nusername = 'cdcuser', password = 'pswd4cdc', \ntable.name = 'students', operation = 'update', \n@map(type='keyvalue', @attributes(id = 'id', name = 'name', \nbefore_id = 'before_id', before_name = 'before_name')))\ndefine stream inputStream (before_id string, id string, \nbefore_name string , name string);", description="In this example, the CDC source listens to the row updates that are made in the 'students' table. This table belongs to the 'SimpleDB' MySQL database that can be accessed via the given URL."), @Example(syntax="@source(type = 'cdc' , url = 'jdbc:mysql://localhost:3306/SimpleDB', \nusername = 'cdcuser', password = 'pswd4cdc', \ntable.name = 'students', operation = 'delete', \n@map(type='keyvalue', @attributes(before_id = 'before_id', before_name = 'before_name')))\ndefine stream inputStream (before_id string, before_name string);", description="In this example, the CDC source listens to the row deletions made in the 'students' table. This table belongs to the 'SimpleDB' database that can be accessed via the given URL."), @Example(syntax="@source(type = 'cdc', mode='polling', polling.column = 'id', \njdbc.driver.name = 'com.mysql.jdbc.Driver', url = 'jdbc:mysql://localhost:3306/SimpleDB', \nusername = 'cdcuser', password = 'pswd4cdc', \ntable.name = 'students', \n@map(type='keyvalue'), @attributes(id = 'id', name = 'name'))\ndefine stream inputStream (id int, name string);", description="In this example, the CDC source polls the 'students' table for inserts. 'id' that is specified as the polling colum' is an auto incremental field. The connection to the database is made via the URL, username, password, and the JDBC driver name."), @Example(syntax="@source(type = 'cdc', mode='polling', polling.column = 'id', datasource.name = 'SimpleDB',\ntable.name = 'students', \n@map(type='keyvalue'), @attributes(id = 'id', name = 'name'))\ndefine stream inputStream (id int, name string);", description="In this example, the CDC source polls the 'students' table for inserts. The given polling column is a char column with the 'S001, S002, ... .' pattern. The connection to the database is made via a data source named 'SimpleDB'. Note that the 'datasource.name' parameter works only with the Stream Processor."), @Example(syntax="@source(type = 'cdc', mode='polling', polling.column = 'last_updated', datasource.name = 'SimpleDB',\ntable.name = 'students', \n@map(type='keyvalue'))\ndefine stream inputStream (name string);", description="In this example, the CDC source polls the 'students' table for inserts and updates. The polling column is a timestamp field.")})
public class CDCSource
extends Source<CdcState> {
    private static final Logger log = Logger.getLogger(CDCSource.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private int pollingInterval;
    private String mode;
    private Map<byte[], byte[]> offsetData = new HashMap<byte[], byte[]>();
    private String operation;
    private ChangeDataCapture changeDataCapture;
    private String historyFileDirectory;
    private CDCSourceObjectKeeper cdcSourceObjectKeeper = CDCSourceObjectKeeper.getCdcSourceObjectKeeper();
    private String carbonHome;
    private CDCPoller cdcPoller;

    protected ServiceDeploymentInfo exposeServiceDeploymentInfo() {
        return null;
    }

    public StateFactory<CdcState> init(SourceEventListener sourceEventListener, OptionHolder optionHolder, String[] requestedTransportPropertyNames, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.mode = optionHolder.validateAndGetStaticValue("mode", "listening");
        String tableName = optionHolder.validateAndGetOption("table.name").getValue();
        switch (this.mode) {
            case "listening": {
                boolean isDirectoryCreated;
                String url = optionHolder.validateAndGetOption("url").getValue();
                String username = optionHolder.validateAndGetOption("username").getValue();
                String password = optionHolder.validateAndGetOption("password").getValue();
                String siddhiAppName = siddhiAppContext.getName();
                String streamName = sourceEventListener.getStreamDefinition().getId();
                this.operation = optionHolder.validateAndGetOption("operation").getValue();
                int serverID = Integer.parseInt(optionHolder.validateAndGetStaticValue("database.server.id", Integer.toString(-1)));
                String serverName = optionHolder.validateAndGetStaticValue("database.server.name", "");
                String connectorProperties = optionHolder.validateAndGetStaticValue("connector.properties", "");
                this.carbonHome = CDCSourceUtil.getCarbonHome();
                this.historyFileDirectory = this.carbonHome + File.separator + "cdc" + File.separator + "history" + File.separator + siddhiAppName + File.separator;
                this.validateListeningModeParameters(optionHolder);
                this.changeDataCapture = new ChangeDataCapture(this.operation, sourceEventListener);
                File directory = new File(this.historyFileDirectory);
                if (!directory.exists() && (isDirectoryCreated = directory.mkdirs()) && log.isDebugEnabled()) {
                    log.debug((Object)"Directory created for history file.");
                }
                try {
                    Map<String, Object> configMap = CDCSourceUtil.getConfigMap(username, password, url, tableName, this.historyFileDirectory, siddhiAppName, streamName, serverID, serverName, connectorProperties, ((Object)((Object)this)).hashCode());
                    this.changeDataCapture.setConfig(configMap);
                    break;
                }
                catch (WrongConfigurationException ex) {
                    throw new SiddhiAppCreationException("The cdc source couldn't get started because of invalid configurations. Found configurations: {username='" + username + "', password=******, url='" + url + "', tablename='" + tableName + "', connetorProperties='" + connectorProperties + "'}", (Throwable)ex);
                }
            }
            case "polling": {
                String password;
                String username;
                String url;
                String driverClassName;
                String pollingColumn = optionHolder.validateAndGetStaticValue("polling.column");
                boolean isDatasourceNameAvailable = optionHolder.isOptionExists("datasource.name");
                boolean isJndiResourceAvailable = optionHolder.isOptionExists("jndi.resource");
                this.pollingInterval = Integer.parseInt(optionHolder.validateAndGetStaticValue("polling.interval", Integer.toString(1)));
                this.validatePollingModeParameters();
                String poolPropertyString = optionHolder.validateAndGetStaticValue("pool.properties", null);
                if (isDatasourceNameAvailable) {
                    String datasourceName = optionHolder.validateAndGetStaticValue("datasource.name");
                    this.cdcPoller = new CDCPoller(null, null, null, tableName, null, datasourceName, null, pollingColumn, this.pollingInterval, poolPropertyString, sourceEventListener, configReader);
                    break;
                }
                if (isJndiResourceAvailable) {
                    String jndiResource = optionHolder.validateAndGetStaticValue("jndi.resource");
                    this.cdcPoller = new CDCPoller(null, null, null, tableName, null, null, jndiResource, pollingColumn, this.pollingInterval, poolPropertyString, sourceEventListener, configReader);
                    break;
                }
                try {
                    driverClassName = optionHolder.validateAndGetStaticValue("jdbc.driver.name");
                    url = optionHolder.validateAndGetOption("url").getValue();
                    username = optionHolder.validateAndGetOption("username").getValue();
                    password = optionHolder.validateAndGetOption("password").getValue();
                }
                catch (SiddhiAppValidationException ex) {
                    throw new SiddhiAppValidationException(ex.getMessage() + " Alternatively, define " + "datasource.name" + " or " + "jndi.resource" + ". Current mode: " + "polling");
                }
                this.cdcPoller = new CDCPoller(url, username, password, tableName, driverClassName, null, null, pollingColumn, this.pollingInterval, poolPropertyString, sourceEventListener, configReader);
                break;
            }
            default: {
                throw new SiddhiAppValidationException("Unsupported mode: " + this.mode);
            }
        }
        return () -> new CdcState(this.mode);
    }

    public Class[] getOutputEventClasses() {
        return new Class[]{Map.class};
    }

    public void connect(Source.ConnectionCallback connectionCallback, CdcState cdcState) throws ConnectionUnavailableException {
        switch (this.mode) {
            case "listening": {
                this.cdcSourceObjectKeeper.addCdcObject(this);
                EmbeddedEngine.CompletionCallback completionCallback = (success, message, error) -> {
                    if (!success) {
                        connectionCallback.onError(new ConnectionUnavailableException("Connection to the database lost.", error));
                    }
                };
                EmbeddedEngine engine = this.changeDataCapture.getEngine(completionCallback);
                this.executorService.execute(engine);
                break;
            }
            case "polling": {
                CDCPoller.CompletionCallback cdcCompletionCallback = error -> {
                    if (!error.getClass().equals(SQLException.class)) {
                        this.destroy();
                        throw new SiddhiAppRuntimeException("CDC Polling mode run failed.", error);
                    }
                    connectionCallback.onError(new ConnectionUnavailableException("Connection to the database lost.", error));
                };
                this.cdcPoller.setCompletionCallback(cdcCompletionCallback);
                this.executorService.execute(this.cdcPoller);
                break;
            }
        }
    }

    public void disconnect() {
        if (this.mode.equals("polling")) {
            this.cdcPoller.pause();
            if (this.cdcPoller.isLocalDataSource()) {
                this.cdcPoller.getDataSource().close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Closing the pool for CDC polling mode.");
                }
            }
        }
    }

    public void destroy() {
        this.disconnect();
        if (this.mode.equals("listening")) {
            this.cdcSourceObjectKeeper.removeObject(((Object)((Object)this)).hashCode());
        }
        this.executorService.shutdown();
    }

    public void pause() {
        switch (this.mode) {
            case "polling": {
                this.cdcPoller.pause();
                break;
            }
            case "listening": {
                this.changeDataCapture.pause();
                break;
            }
        }
    }

    public void resume() {
        switch (this.mode) {
            case "polling": {
                this.cdcPoller.resume();
                break;
            }
            case "listening": {
                this.changeDataCapture.resume();
                break;
            }
        }
    }

    public Map<byte[], byte[]> getOffsetData() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            log.error((Object)"Offset data retrieval failed.", (Throwable)e);
        }
        return this.offsetData;
    }

    public void setOffsetData(Map<byte[], byte[]> offsetData) {
        this.offsetData = offsetData;
    }

    private void validateListeningModeParameters(OptionHolder optionHolder) {
        if (optionHolder.isOptionExists("datasource.name")) {
            throw new SiddhiAppValidationException("Parameter: datasource.name should not be defined for listening mode");
        }
        if (!(this.operation.equalsIgnoreCase("insert") || this.operation.equalsIgnoreCase("update") || this.operation.equalsIgnoreCase("delete"))) {
            throw new SiddhiAppValidationException("Unsupported operation: '" + this.operation + "'. operation should be one of 'insert', 'update' or 'delete'");
        }
        if (this.carbonHome.isEmpty()) {
            throw new SiddhiAppValidationException("Couldn't initialize Carbon Home.");
        }
        if (!this.historyFileDirectory.endsWith(File.separator)) {
            this.historyFileDirectory = this.historyFileDirectory + File.separator;
        }
    }

    private void validatePollingModeParameters() {
        if (this.pollingInterval < 0) {
            throw new SiddhiAppValidationException("polling.interval should be a non negative integer. Current mode: polling");
        }
    }

    class CdcState
    extends State {
        private final String mode;
        private final Map<String, Object> state;

        private CdcState(String mode) {
            this.mode = mode;
            this.state = new HashMap<String, Object>();
        }

        public boolean canDestroy() {
            return false;
        }

        public Map<String, Object> snapshot() {
            switch (this.mode) {
                case "polling": {
                    this.state.put("last.offset", CDCSource.this.cdcPoller.getLastReadPollingColumnValue());
                    break;
                }
                case "listening": {
                    this.state.put("cacheObj", CDCSource.this.offsetData);
                    break;
                }
            }
            return this.state;
        }

        public void restore(Map<String, Object> map) {
            switch (this.mode) {
                case "polling": {
                    Object lastOffsetObj = map.get("last.offset");
                    CDCSource.this.cdcPoller.setLastReadPollingColumnValue((String)lastOffsetObj);
                    break;
                }
                case "listening": {
                    Object cacheObj = map.get("cacheObj");
                    CDCSource.this.offsetData = (HashMap)cacheObj;
                    break;
                }
            }
        }
    }
}

