/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.util;

import io.siddhi.extension.io.cdc.source.listening.InMemoryOffsetBackingStore;
import io.siddhi.extension.io.cdc.source.listening.WrongConfigurationException;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CDCSourceUtil {
    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> getConfigMap(String username, String password, String url, String tableName, String historyFileDirectory, String siddhiAppName, String siddhiStreamName, int serverID, String serverName, String connectorProperties, int cdcSourceHashCode) throws WrongConfigurationException {
        int port;
        String host;
        void var17_18;
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        String[] splittedURL = url.split(":");
        if (!splittedURL[0].equalsIgnoreCase("jdbc")) {
            throw new WrongConfigurationException("Invalid JDBC url: " + url + " received for stream: " + siddhiStreamName + ". Expected url format: jdbc:mysql://<host>:<port>/<database_name>");
        }
        String string = splittedURL[1];
        int n = -1;
        switch (string.hashCode()) {
            case 104382626: {
                if (!string.equals("mysql")) break;
                boolean bl = false;
                break;
            }
            case -2105481388: {
                if (!string.equals("postgresql")) break;
                boolean bl = true;
                break;
            }
            case -1874470255: {
                if (!string.equals("sqlserver")) break;
                int n2 = 2;
            }
        }
        switch (var17_18) {
            case 0: {
                String regex = "jdbc:mysql://(\\w*|[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}):(\\d++)/(\\w*)";
                Pattern p = Pattern.compile(regex);
                Matcher matcher = p.matcher(url);
                if (!matcher.find()) {
                    throw new WrongConfigurationException("Invalid JDBC url: " + url + " received for stream: " + siddhiStreamName + ". Expected url format: jdbc:mysql://<host>:<port>/<database_name>");
                }
                host = matcher.group(1);
                port = Integer.parseInt(matcher.group(2));
                String database = matcher.group(3);
                configMap.put("database.port", port);
                configMap.put("table.whitelist", database + "." + tableName);
                configMap.put("database.hostname", host);
                configMap.put("connector.class", "io.debezium.connector.mysql.MySqlConnector");
                break;
            }
            case 1: {
                String regex = "jdbc:postgresql://(\\w*|[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}):(\\d++)/(\\w*)";
                Pattern p = Pattern.compile(regex);
                Matcher matcher = p.matcher(url);
                if (!matcher.find()) {
                    throw new WrongConfigurationException("Invalid JDBC url: " + url + " received for stream: " + siddhiStreamName + ". Expected url format: jdbc:postgresql://<host>:<port>/<database_name>");
                }
                host = matcher.group(1);
                port = Integer.parseInt(matcher.group(2));
                String database = matcher.group(3);
                configMap.put("database.hostname", host);
                configMap.put("database.port", port);
                configMap.put("database.dbname", database);
                configMap.put("table.whitelist", tableName);
                configMap.put("connector.class", "io.debezium.connector.postgresql.PostgresConnector");
                break;
            }
            case 2: {
                String regex = "jdbc:sqlserver://(\\w*|[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}):(\\d++);databaseName=(\\w*)";
                Pattern p = Pattern.compile(regex);
                Matcher matcher = p.matcher(url);
                if (!matcher.find()) {
                    throw new WrongConfigurationException("Invalid JDBC url: " + url + " received for stream: " + siddhiStreamName + ". Expected url format: jdbc:sqlserver://<host>:<port>;databaseName=<database_name>");
                }
                host = matcher.group(1);
                port = Integer.parseInt(matcher.group(2));
                String database = matcher.group(3);
                configMap.put("database.hostname", host);
                configMap.put("database.port", port);
                configMap.put("table.whitelist", tableName);
                configMap.put("database.dbname", database);
                configMap.put("connector.class", "io.debezium.connector.sqlserver.SqlServerConnector");
                break;
            }
            default: {
                throw new WrongConfigurationException("Unsupported schema. Expected schema: mysql or postgresqlor sqlserver, Found: " + splittedURL[1]);
            }
        }
        configMap.put("database.user", username);
        configMap.put("database.password", password);
        if (serverID == -1) {
            Random random = new Random();
            configMap.put("server.id", random.nextInt(1001) + 5400);
        } else {
            configMap.put("server.id", serverID);
        }
        if (serverName.equals("")) {
            configMap.put("database.server.name", host + "_" + port);
        } else {
            configMap.put("database.server.name", serverName);
        }
        configMap.put("offset.storage", InMemoryOffsetBackingStore.class.getName());
        configMap.put("cdc.source.object", cdcSourceHashCode);
        configMap.put("database.history", "io.debezium.relational.history.FileDatabaseHistory");
        configMap.put("database.history.file.filename", historyFileDirectory + siddhiStreamName + ".dat");
        configMap.put("name", siddhiAppName + siddhiStreamName);
        for (Map.Entry entry : CDCSourceUtil.getConnectorPropertiesMap(connectorProperties).entrySet()) {
            configMap.put((String)entry.getKey(), entry.getValue());
        }
        return configMap;
    }

    private static Map<String, String> getConnectorPropertiesMap(String connectorProperties) {
        HashMap<String, String> connectorPropertiesMap = new HashMap<String, String>();
        if (!connectorProperties.isEmpty()) {
            String[] keyValuePairs;
            for (String keyValuePair : keyValuePairs = connectorProperties.split(",")) {
                String[] keyAndValue = keyValuePair.split("=");
                if (keyAndValue.length == 2) continue;
                throw new SiddhiAppValidationException("connector.properties input is invalid. Check near :" + keyValuePair);
            }
        }
        return connectorPropertiesMap;
    }

    public static String getCarbonHome() {
        String path = System.getProperty("carbon.home");
        if (path == null) {
            path = System.getProperty("user.dir");
        }
        return path;
    }
}

