/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.FieldSelector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.function.Predicates;
import io.debezium.util.Collect;
import java.util.Set;
import java.util.function.Predicate;

public final class Filters {
    protected static final Set<String> BUILT_IN_DB_NAMES = Collect.unmodifiableSet("local", "admin");
    private final Predicate<String> databaseFilter;
    private final Predicate<CollectionId> collectionFilter;
    private final FieldSelector fieldSelector;

    public Filters(Configuration config) {
        String dbWhitelist = config.getString(MongoDbConnectorConfig.DATABASE_WHITELIST);
        String dbBlacklist = config.getString(MongoDbConnectorConfig.DATABASE_BLACKLIST);
        this.databaseFilter = dbWhitelist != null && !dbWhitelist.trim().isEmpty() ? Predicates.includes(dbWhitelist) : (dbBlacklist != null && !dbBlacklist.trim().isEmpty() ? Predicates.excludes(dbBlacklist) : db -> true);
        String collectionWhitelist = config.getString(MongoDbConnectorConfig.COLLECTION_WHITELIST);
        String collectionBlacklist = config.getString(MongoDbConnectorConfig.COLLECTION_BLACKLIST);
        Predicate<CollectionId> collectionFilter = collectionWhitelist != null && !collectionWhitelist.trim().isEmpty() ? Predicates.includes(collectionWhitelist, CollectionId::namespace) : (collectionBlacklist != null && !collectionBlacklist.trim().isEmpty() ? Predicates.excludes(collectionBlacklist, CollectionId::namespace) : id -> true);
        Predicate<CollectionId> isNotBuiltIn = this::isNotBuiltIn;
        this.collectionFilter = isNotBuiltIn.and(collectionFilter);
        this.fieldSelector = FieldSelector.builder().excludeFields(config.getString(MongoDbConnectorConfig.FIELD_BLACKLIST)).renameFields(config.getString(MongoDbConnectorConfig.FIELD_RENAMES)).build();
    }

    public Predicate<String> databaseFilter() {
        return this.databaseFilter;
    }

    public Predicate<CollectionId> collectionFilter() {
        return this.collectionFilter;
    }

    public FieldSelector.FieldFilter fieldFilterFor(CollectionId id) {
        return this.fieldSelector.fieldFilterFor(id);
    }

    protected boolean isNotBuiltIn(CollectionId id) {
        return !BUILT_IN_DB_NAMES.contains(id.dbName());
    }
}

