/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbOffsetContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.schema.DataCollectionId;
import java.time.Instant;
import java.util.Map;
import java.util.OptionalLong;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.bson.BsonTimestamp;
import org.bson.Document;

@ThreadSafe
public class ReplicaSetOffsetContext
implements OffsetContext {
    private final MongoDbOffsetContext offsetContext;
    private final String replicaSetName;
    private final SourceInfo sourceInfo;

    public ReplicaSetOffsetContext(MongoDbOffsetContext offsetContext, ReplicaSet replicaSet, SourceInfo sourceInfo) {
        this.offsetContext = offsetContext;
        this.replicaSetName = replicaSet.replicaSetName();
        this.sourceInfo = sourceInfo;
    }

    @Override
    public Map<String, ?> getPartition() {
        return this.sourceInfo.partition(this.replicaSetName);
    }

    @Override
    public Map<String, ?> getOffset() {
        Map<String, Object> offsets = this.sourceInfo.lastOffset(this.replicaSetName);
        return this.isSnapshotOngoing() ? offsets : this.offsetContext.getTransactionContext().store(offsets);
    }

    @Override
    public Schema getSourceInfoSchema() {
        return this.offsetContext.getSourceInfoSchema();
    }

    @Override
    public Struct getSourceInfo() {
        return this.offsetContext.getSourceInfo();
    }

    @Override
    public boolean isSnapshotRunning() {
        return this.offsetContext.isSnapshotRunning();
    }

    @Override
    public void markLastSnapshotRecord() {
        this.offsetContext.markLastSnapshotRecord();
    }

    @Override
    public void preSnapshotStart() {
        this.offsetContext.preSnapshotStart();
    }

    @Override
    public void preSnapshotCompletion() {
        this.offsetContext.preSnapshotCompletion();
    }

    @Override
    public void postSnapshotCompletion() {
        this.offsetContext.postSnapshotCompletion();
    }

    @Override
    public void event(DataCollectionId collectionId, Instant timestamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.offsetContext.getTransactionContext();
    }

    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    public boolean isSnapshotOngoing() {
        return this.sourceInfo.isInitialSyncOngoing(this.replicaSetName);
    }

    public boolean hasOffset() {
        return this.sourceInfo.hasOffset(this.replicaSetName);
    }

    public void readEvent(CollectionId collectionId, Instant timestamp) {
        this.sourceInfo.collectionEvent(this.replicaSetName, collectionId);
        this.sourceInfo.lastOffset(this.replicaSetName);
    }

    public void oplogEvent(Document oplogEvent, Document masterEvent, Long txOrder) {
        this.sourceInfo.opLogEvent(this.replicaSetName, oplogEvent, masterEvent, txOrder);
    }

    public BsonTimestamp lastOffsetTimestamp() {
        return this.sourceInfo.lastOffsetTimestamp(this.replicaSetName);
    }

    public OptionalLong lastOffsetTxOrder() {
        return this.sourceInfo.lastOffsetTxOrder(this.replicaSetName);
    }
}

