/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.listener.MySqlAntlrDdlParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlLexer;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySqlAntlrDdlParser
extends AntlrDdlParser<MySqlLexer, MySqlParser> {
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();
    private final MySqlValueConverters converters;
    private final Tables.TableFilter tableFilter;

    public MySqlAntlrDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters) {
        this(converters, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        this(true, false, converters, tableFilter);
    }

    protected MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews);
        this.systemVariables = new MySqlSystemVariables();
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    @Override
    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    @Override
    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MySqlAntlrDdlParserListener(this);
    }

    @Override
    protected MySqlLexer createNewLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    @Override
    protected MySqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser(commonTokenStream);
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return new MySqlSystemVariables();
    }

    @Override
    protected boolean isGrammarInUpperCase() {
        return true;
    }

    @Override
    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 199), new DataTypeResolver.DataTypeEntry(12, 200), new DataTypeResolver.DataTypeEntry(12, 209), new DataTypeResolver.DataTypeEntry(12, 210), new DataTypeResolver.DataTypeEntry(12, 211), new DataTypeResolver.DataTypeEntry(12, 212), new DataTypeResolver.DataTypeEntry(-15, 437), new DataTypeResolver.DataTypeEntry(-9, 201), new DataTypeResolver.DataTypeEntry(-2, 199, 203), new DataTypeResolver.DataTypeEntry(-2, 200, 203), new DataTypeResolver.DataTypeEntry(-2, 209, 203), new DataTypeResolver.DataTypeEntry(-2, 210, 203), new DataTypeResolver.DataTypeEntry(-2, 211, 203), new DataTypeResolver.DataTypeEntry(-2, 212, 203), new DataTypeResolver.DataTypeEntry(-2, 437, 203), new DataTypeResolver.DataTypeEntry(-2, 201, 203)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 202, 200).setSuffixTokens(203), new DataTypeResolver.DataTypeEntry(-15, 202, 22).setSuffixTokens(203), new DataTypeResolver.DataTypeEntry(-9, 437, 200).setSuffixTokens(203)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 202, 199, 214), new DataTypeResolver.DataTypeEntry(-9, 202, 22, 214)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, 180).setSuffixTokens(512, 166, 179), new DataTypeResolver.DataTypeEntry(5, 181).setSuffixTokens(512, 166, 179), new DataTypeResolver.DataTypeEntry(4, 182).setSuffixTokens(512, 166, 179), new DataTypeResolver.DataTypeEntry(4, 183).setSuffixTokens(512, 166, 179), new DataTypeResolver.DataTypeEntry(4, 184).setSuffixTokens(512, 166, 179), new DataTypeResolver.DataTypeEntry(-5, 185).setSuffixTokens(512, 166, 179), new DataTypeResolver.DataTypeEntry(7, 186).setSuffixTokens(512, 166, 179), new DataTypeResolver.DataTypeEntry(8, 187).setSuffixTokens(188, 512, 166, 179), new DataTypeResolver.DataTypeEntry(6, 189).setSuffixTokens(512, 166, 179), new DataTypeResolver.DataTypeEntry(3, 190).setSuffixTokens(512, 166, 179).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 191).setSuffixTokens(512, 166, 179).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 192).setSuffixTokens(512, 166, 179).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, 193).setSuffixTokens(512, 166, 179).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, 276), new DataTypeResolver.DataTypeEntry(92, 195), new DataTypeResolver.DataTypeEntry(2014, 196), new DataTypeResolver.DataTypeEntry(93, 197), new DataTypeResolver.DataTypeEntry(-2, 203), new DataTypeResolver.DataTypeEntry(-3, 204), new DataTypeResolver.DataTypeEntry(4, 198)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, 194), new DataTypeResolver.DataTypeEntry(2004, 205), new DataTypeResolver.DataTypeEntry(2004, 206), new DataTypeResolver.DataTypeEntry(2004, 207), new DataTypeResolver.DataTypeEntry(2004, 208), new DataTypeResolver.DataTypeEntry(16, 278), new DataTypeResolver.DataTypeEntry(16, 279), new DataTypeResolver.DataTypeEntry(-5, 215)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 213).setSuffixTokens(203), new DataTypeResolver.DataTypeEntry(1, 138).setSuffixTokens(203)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, 657), new DataTypeResolver.DataTypeEntry(1111, 658), new DataTypeResolver.DataTypeEntry(1111, 660), new DataTypeResolver.DataTypeEntry(1111, 661), new DataTypeResolver.DataTypeEntry(1111, 662), new DataTypeResolver.DataTypeEntry(1111, 663), new DataTypeResolver.DataTypeEntry(1111, 664), new DataTypeResolver.DataTypeEntry(1111, 665), new DataTypeResolver.DataTypeEntry(1111, 386), new DataTypeResolver.DataTypeEntry(1111, 659)));
        return dataTypeResolverBuilder.build();
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MySqlParser.UidContext uidContext) {
        return this.withoutQuotes(uidContext);
    }

    public TableId parseQualifiedTableId(MySqlParser.FullIdContext fullIdContext) {
        char[] fullTableName = fullIdContext.getText().toCharArray();
        StringBuilder component = new StringBuilder();
        String dbName = null;
        String tableName = null;
        boolean EMPTY = false;
        char lastQuote = '\u0000';
        for (int i = 0; i < fullTableName.length; ++i) {
            char c = fullTableName[i];
            if (MySqlAntlrDdlParser.isQuote(c)) {
                if (lastQuote == '\u0000') {
                    lastQuote = c;
                    continue;
                }
                if (lastQuote == c) {
                    if (i < fullTableName.length - 1 && fullTableName[i + 1] == c) {
                        component.append(c);
                        ++i;
                        continue;
                    }
                    lastQuote = '\u0000';
                    continue;
                }
                component.append(c);
                continue;
            }
            if (c == '.' && lastQuote == '\u0000') {
                dbName = component.toString();
                component = new StringBuilder();
                continue;
            }
            component.append(c);
        }
        tableName = component.toString();
        return this.resolveTableId(dbName != null ? dbName : this.currentSchema(), tableName);
    }

    public void parsePrimaryIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List<String> pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : MySqlAntlrDdlParser.withoutQuotes(indexColumnNameContext.STRING_LITERAL().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                ColumnEditor ce = column.edit().optional(false);
                if (ce.hasDefaultValue() && ce.defaultValue() == null) {
                    ce.unsetDefaultValue();
                }
                tableEditor.addColumn(ce.create());
            }
            return columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> extractEnumAndSetOptions(List<String> enumValues) {
        return enumValues.stream().map(AbstractDdlParser::withoutQuotes).map(MySqlAntlrDdlParser::escapeOption).collect(Collectors.toList());
    }

    public static String escapeOption(String option) {
        return option.replaceAll(",", "\\\\,").replaceAll("\\\\'", "'").replaceAll("''", "'");
    }

    public MySqlValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }
}

