/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.oracle.antlr.listener.OracleDdlParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlLexer;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Tables;
import java.util.Arrays;
import java.util.Locale;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleDdlParser
extends AntlrDdlParser<PlSqlLexer, PlSqlParser> {
    private String catalogName;
    private String schemaName;

    public OracleDdlParser() {
        super(true);
    }

    public OracleDdlParser(boolean throwErrorsFromTreeWalk, String catalogName, String schemaName) {
        super(throwErrorsFromTreeWalk);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    @Override
    public void parse(String ddlContent, Tables databaseTables) {
        if (!ddlContent.endsWith(";")) {
            ddlContent = ddlContent + ";";
        }
        super.parse(this.toUpperCase(ddlContent), databaseTables);
    }

    @Override
    public ParseTree parseTree(PlSqlParser parser) {
        return parser.unit_statement();
    }

    @Override
    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new OracleDdlParserListener(this.catalogName, this.schemaName, this);
    }

    @Override
    protected PlSqlLexer createNewLexerInstance(CharStream charStreams) {
        return new PlSqlLexer(charStreams);
    }

    @Override
    protected PlSqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new PlSqlParser(commonTokenStream);
    }

    @Override
    protected boolean isGrammarInUpperCase() {
        return true;
    }

    @Override
    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(PlSqlParser.Native_datatype_elementContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2, 684), new DataTypeResolver.DataTypeEntry(2, 676), new DataTypeResolver.DataTypeEntry(2, 1532), new DataTypeResolver.DataTypeEntry(2, 1094), new DataTypeResolver.DataTypeEntry(2, 339), new DataTypeResolver.DataTypeEntry(2, 1093), new DataTypeResolver.DataTypeEntry(93, 323), new DataTypeResolver.DataTypeEntry(-102, 1924), new DataTypeResolver.DataTypeEntry(-101, 1924), new DataTypeResolver.DataTypeEntry(93, 1924), new DataTypeResolver.DataTypeEntry(12, 2066), new DataTypeResolver.DataTypeEntry(12, 2067), new DataTypeResolver.DataTypeEntry(-9, 1098), new DataTypeResolver.DataTypeEntry(1, 173), new DataTypeResolver.DataTypeEntry(-15, 884), new DataTypeResolver.DataTypeEntry(100, 113), new DataTypeResolver.DataTypeEntry(101, 110), new DataTypeResolver.DataTypeEntry(6, 528), new DataTypeResolver.DataTypeEntry(6, 1348), new DataTypeResolver.DataTypeEntry(2004, 126), new DataTypeResolver.DataTypeEntry(2005, 189)));
        return dataTypeResolverBuilder.build();
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return null;
    }

    @Override
    public void setCurrentDatabase(String databaseName) {
        this.catalogName = databaseName;
    }

    @Override
    public void setCurrentSchema(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public SystemVariables systemVariables() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    private String toUpperCase(String ddl) {
        return ddl.toUpperCase(Locale.ENGLISH);
    }
}

