/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.metrics;

import io.siddhi.extension.io.cdc.source.metrics.CDCStatus;
import io.siddhi.extension.io.cdc.source.metrics.Metrics;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

public class ListeningMetrics
extends Metrics {
    private static final Logger log = Logger.getLogger(ListeningMetrics.class);
    private final String operationType;
    private boolean isLastReceivedTimeMetricsRegistered;
    private long lastReceivedTime;

    public ListeningMetrics(String siddhiAppName, String dbURL, String tableName, String operationType) {
        super(siddhiAppName, dbURL, tableName);
        this.operationType = operationType.substring(0, 1).toUpperCase(Locale.ENGLISH) + operationType.substring(1);
        CDC_STATUS_SERVICE_STARTED_MAP.putIfAbsent(siddhiAppName, false);
    }

    @Override
    public void updateTableStatus(ExecutorService executorService, String siddhiAppName) {
        if (!((Boolean)CDC_STATUS_SERVICE_STARTED_MAP.get(siddhiAppName)).booleanValue()) {
            CDC_STATUS_SERVICE_STARTED_MAP.replace(siddhiAppName, true);
            executorService.execute(() -> {
                while (((Boolean)CDC_STATUS_SERVICE_STARTED_MAP.get(siddhiAppName)).booleanValue()) {
                    if (!CDC_STATUS_MAP.isEmpty()) {
                        CDC_LAST_RECEIVED_TIME_MAP.forEach((cdcDatabase, lastReceiveTime) -> {
                            long idleTime;
                            if (cdcDatabase.siddhiAppName.equals(siddhiAppName) && (idleTime = System.currentTimeMillis() - lastReceiveTime) / 1000L > 8L) {
                                CDC_STATUS_MAP.replace(cdcDatabase, CDCStatus.IDLE);
                            }
                        });
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)(siddhiAppName + ": Error while updating the tables status."));
                    }
                }
            });
        }
    }

    @Override
    public Counter getEventCountMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Listening.event.count.%s.%s.host.%s.%s.%s.%s", this.siddhiAppName, this.dbType, this.host, this.operationType, this.databaseName, this.tableName, this.getDatabaseURL()), Level.INFO, new Level[0]);
    }

    public Counter getTotalEventCounterMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Listening.events.per.table.%s.%s", this.siddhiAppName, this.tableName, this.getDatabaseURL()), Level.INFO, new Level[0]);
    }

    public Counter getValidEventCountMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Listening.%s.%s", this.siddhiAppName, "total_valid_events_count", this.getDatabaseURL()), Level.INFO, new Level[0]);
    }

    private Counter getTotalErrorCountMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Listening.%s.%s", this.siddhiAppName, "total_error_count", this.getDatabaseURL()), Level.INFO, new Level[0]);
    }

    @Override
    protected void lastReceivedTimeMetric() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Listening.%s.%s", this.siddhiAppName, "last_receive_time", this.getDatabaseURL()), Level.INFO, () -> {
            if (CDC_LAST_RECEIVED_TIME_MAP.containsKey(this.cdcDatabase)) {
                return (Long)CDC_LAST_RECEIVED_TIME_MAP.get(this.cdcDatabase);
            }
            return 0L;
        });
    }

    private void setLastReceivedTimeByOperationMetric() {
        if (!this.isLastReceivedTimeMetricsRegistered) {
            MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Listening.%s.%s.%s", this.siddhiAppName, "last_receive_time_by_operation", this.operationType, this.getDatabaseURL()), Level.INFO, () -> {
                ListeningMetrics listeningMetrics = this;
                synchronized (listeningMetrics) {
                    return this.lastReceivedTime;
                }
            });
            this.isLastReceivedTimeMetricsRegistered = true;
        }
    }

    @Override
    protected void idleTimeMetric() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Listening.%s.%s", this.siddhiAppName, "idle_time", this.getDatabaseURL()), Level.INFO, () -> {
            if (CDC_LAST_RECEIVED_TIME_MAP.containsKey(this.cdcDatabase)) {
                return (System.currentTimeMillis() - (Long)CDC_LAST_RECEIVED_TIME_MAP.get(this.cdcDatabase)) / 1000L;
            }
            return 0L;
        });
    }

    @Override
    protected void setCDCDBStatusMetric() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Listening.%s.%s", this.siddhiAppName, "db_status", this.getDatabaseURL()), Level.INFO, () -> {
            if (CDC_STATUS_MAP.containsKey(this.cdcDatabase)) {
                return ((CDCStatus)((Object)((Object)CDC_STATUS_MAP.get(this.cdcDatabase)))).ordinal();
            }
            return -1;
        });
    }

    @Override
    public synchronized void setCDCStatus(CDCStatus cdcStatus) {
        if (cdcStatus == CDCStatus.ERROR) {
            this.getTotalErrorCountMetric().inc();
        }
        if (CDC_STATUS_MAP.containsKey(this.cdcDatabase)) {
            CDC_STATUS_MAP.replace(this.cdcDatabase, cdcStatus);
        } else {
            CDC_STATUS_MAP.put(this.cdcDatabase, cdcStatus);
            this.setCDCDBStatusMetric();
        }
    }

    @Override
    public synchronized void setLastReceivedTime(long lastReceivedTime) {
        this.lastReceivedTime = lastReceivedTime;
        this.setLastReceivedTimeByOperationMetric();
        if (CDC_LAST_RECEIVED_TIME_MAP.containsKey(this.cdcDatabase)) {
            if ((Long)CDC_LAST_RECEIVED_TIME_MAP.get(this.cdcDatabase) < lastReceivedTime) {
                CDC_LAST_RECEIVED_TIME_MAP.replace(this.cdcDatabase, lastReceivedTime);
            }
        } else {
            CDC_LAST_RECEIVED_TIME_MAP.put(this.cdcDatabase, lastReceivedTime);
            this.lastReceivedTimeMetric();
            this.idleTimeMetric();
            this.getTotalErrorCountMetric();
        }
    }
}

