/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.metrics;

public class MetricsUtils {
    private static String getShortenedURL(String jdbcURL) {
        if (jdbcURL.length() <= 30) {
            return jdbcURL;
        }
        int n = jdbcURL.length();
        int i = 30;
        char c = jdbcURL.charAt(i);
        while (Character.isLetterOrDigit(c) && i != n - 1) {
            c = jdbcURL.charAt(++i);
        }
        if (i == n - 1) {
            return jdbcURL;
        }
        return jdbcURL.substring(0, i) + "..";
    }

    public static String getShortenedJDBCURL(String url) {
        String formattedURL;
        String[] splittedURL = url.split(":");
        switch (splittedURL[1]) {
            case "mysql": 
            case "postgresql": {
                String[] split = url.split("\\?");
                if (split.length == 1) {
                    formattedURL = split[0];
                    break;
                }
                formattedURL = split[0] + "..";
                break;
            }
            case "sqlserver": 
            case "derby": {
                String[] split = url.split(";");
                if (split.length == 1) {
                    formattedURL = split[0];
                    break;
                }
                formattedURL = split[0] + "..";
                break;
            }
            case "oracle": {
                url = new StringBuilder(url).reverse().toString();
                url = url.replaceAll("@.*?:", "@");
                url = new StringBuilder(url).reverse().toString();
                int index = url.indexOf(64);
                int split = 0;
                for (int i = index + 1; i < url.length(); ++i) {
                    if (url.charAt(i) != ':') continue;
                    split = i;
                    break;
                }
                if (split != 0) {
                    formattedURL = url.substring(0, split) + "..";
                    break;
                }
                formattedURL = url;
                break;
            }
            case "db2": {
                int index = url.lastIndexOf("db2:") + 3;
                int split = 0;
                for (int i = index + 1; i < url.length(); ++i) {
                    if (url.charAt(i) != ':') continue;
                    split = i;
                    break;
                }
                if (split != 0) {
                    formattedURL = url.substring(0, split) + "..";
                    break;
                }
                formattedURL = url;
                break;
            }
            default: {
                formattedURL = url;
            }
        }
        return MetricsUtils.getShortenedURL(formattedURL);
    }
}

