/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.polling;

import io.siddhi.extension.io.cdc.source.config.CronConfiguration;
import io.siddhi.extension.io.cdc.source.polling.strategies.PollingStrategy;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class CDCCronExecutor
implements Job {
    private static final Logger log = Logger.getLogger(CDCCronExecutor.class);

    public static void scheduleJob(PollingStrategy pollingStrategy, CronConfiguration cronConfiguration) {
        try {
            String cronExpression = cronConfiguration.getCronExpression();
            JobKey jobKey = new JobKey("CDCPollingJobName", "CDCPollingGroup");
            Scheduler scheduler = new StdSchedulerFactory().getScheduler();
            if (scheduler.checkExists(jobKey)) {
                scheduler.deleteJob(jobKey);
            }
            scheduler.start();
            cronConfiguration.setScheduler(scheduler);
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("PollingStrategy", (Object)pollingStrategy);
            JobDetail cron = JobBuilder.newJob(CDCCronExecutor.class).usingJobData(dataMap).withIdentity(jobKey).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("CDCCronTriggerName", "CDCCronTriggerGroup").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
            scheduler.scheduleJob(cron, trigger);
        }
        catch (SchedulerException e) {
            log.error((Object)("An error occurred when scheduling job in siddhi app for cdc polling " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        PollingStrategy pollingStrategy = (PollingStrategy)dataMap.get((Object)"PollingStrategy");
        pollingStrategy.poll();
    }
}

