/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.polling;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.extension.io.cdc.source.config.CronConfiguration;
import io.siddhi.extension.io.cdc.source.metrics.PollingMetrics;
import io.siddhi.extension.io.cdc.source.polling.CDCCronExecutor;
import io.siddhi.extension.io.cdc.source.polling.CDCPollingModeException;
import io.siddhi.extension.io.cdc.source.polling.strategies.DefaultPollingStrategy;
import io.siddhi.extension.io.cdc.source.polling.strategies.PollingStrategy;
import io.siddhi.extension.io.cdc.source.polling.strategies.WaitOnMissingRecordPollingStrategy;
import io.siddhi.extension.io.cdc.util.CDCPollingUtil;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

public class CDCPoller
implements Runnable {
    private static final Logger log = Logger.getLogger(CDCPoller.class);
    private String url;
    private String tableName;
    private String username;
    private String password;
    private String driverClassName;
    private HikariDataSource dataSource;
    private String datasourceName;
    private CompletionCallback completionCallback;
    private String poolPropertyString;
    private String jndiResource;
    private boolean isLocalDataSource = false;
    private String appName;
    private String streamName;
    private PollingStrategy pollingStrategy;
    private final CronConfiguration cronConfiguration;

    public CDCPoller(String url, String username, String password, String tableName, String driverClassName, String datasourceName, String jndiResource, String pollingColumn, int pollingInterval, String poolPropertyString, SourceEventListener sourceEventListener, ConfigReader configReader, boolean waitOnMissedRecord, int missedRecordWaitingTimeout, String appName, PollingMetrics pollingMetrics, CronConfiguration cronConfiguration) {
        this.url = url;
        this.tableName = tableName;
        this.username = username;
        this.password = password;
        this.driverClassName = driverClassName;
        this.poolPropertyString = poolPropertyString;
        this.datasourceName = datasourceName;
        this.jndiResource = jndiResource;
        this.appName = appName;
        this.streamName = sourceEventListener.getStreamDefinition().getId();
        this.cronConfiguration = cronConfiguration;
        try {
            this.initializeDatasource();
        }
        catch (NamingException e) {
            throw new CDCPollingModeException("Error in initializing connection for " + tableName + ". {mode=" + "polling" + ", app=" + appName + ", stream=" + this.streamName + "}", e);
        }
        if (waitOnMissedRecord) {
            log.debug((Object)(WaitOnMissingRecordPollingStrategy.class + " is selected as the polling strategy."));
            this.pollingStrategy = new WaitOnMissingRecordPollingStrategy(this.dataSource, configReader, sourceEventListener, tableName, pollingColumn, pollingInterval, missedRecordWaitingTimeout, appName, pollingMetrics);
        } else {
            log.debug((Object)(DefaultPollingStrategy.class + " is selected as the polling strategy."));
            this.pollingStrategy = new DefaultPollingStrategy(this.dataSource, configReader, sourceEventListener, tableName, pollingColumn, pollingInterval, appName, pollingMetrics, cronConfiguration);
        }
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    public void setCompletionCallback(CompletionCallback completionCallback) {
        this.completionCallback = completionCallback;
    }

    private void initializeDatasource() throws NamingException {
        if (this.datasourceName == null) {
            if (this.jndiResource == null) {
                Properties connectionProperties = new Properties();
                connectionProperties.setProperty("jdbcUrl", this.url);
                connectionProperties.setProperty("dataSource.user", this.username);
                if (!CDCPollingUtil.isEmpty(this.password)) {
                    connectionProperties.setProperty("dataSource.password", this.password);
                }
                connectionProperties.setProperty("driverClassName", this.driverClassName);
                if (this.poolPropertyString != null) {
                    List<String[]> poolProps = CDCPollingUtil.processKeyValuePairs(this.poolPropertyString);
                    poolProps.forEach(pair -> connectionProperties.setProperty(pair[0], pair[1]));
                }
                HikariConfig config = new HikariConfig(connectionProperties);
                this.dataSource = new HikariDataSource(config);
                this.isLocalDataSource = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Database connection for '" + this.tableName + "' created through connection parameters specified in the query."));
                }
            } else {
                this.dataSource = (HikariDataSource)InitialContext.doLookup(this.jndiResource);
                this.isLocalDataSource = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Lookup for resource '" + this.jndiResource + "' completed through JNDI lookup."));
                }
            }
        } else {
            try {
                BundleContext bundleContext = FrameworkUtil.getBundle(DataSourceService.class).getBundleContext();
                ServiceReference serviceRef = bundleContext.getServiceReference(DataSourceService.class.getName());
                if (serviceRef == null) {
                    throw new CDCPollingModeException("DatasourceService : '" + DataSourceService.class.getCanonicalName() + "' cannot be found.");
                }
                DataSourceService dataSourceService = (DataSourceService)bundleContext.getService(serviceRef);
                this.dataSource = (HikariDataSource)dataSourceService.getDataSource(this.datasourceName);
                this.isLocalDataSource = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Lookup for datasource '" + this.datasourceName + "' completed through DataSource Service lookup. Current mode: " + "polling"));
                }
            }
            catch (DataSourceException e) {
                throw new CDCPollingModeException("Datasource '" + this.datasourceName + "' cannot be connected. Current mode: " + "polling", e);
            }
        }
    }

    public boolean isLocalDataSource() {
        return this.isLocalDataSource;
    }

    public String getLastReadPollingColumnValue() {
        return this.pollingStrategy.getLastReadPollingColumnValue();
    }

    public void setLastReadPollingColumnValue(String lastReadPollingColumnValue) {
        this.pollingStrategy.setLastReadPollingColumnValue(lastReadPollingColumnValue);
    }

    public void pause() {
        this.pollingStrategy.pause();
    }

    public void stop() {
        if (this.isLocalDataSource) {
            this.dataSource.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing the pool for CDC polling mode.");
            }
        }
    }

    public void resume() {
        this.pollingStrategy.resume();
    }

    @Override
    public void run() {
        try {
            this.pollingStrategy.poll();
            if (this.cronConfiguration.getCronExpression() != null) {
                CDCCronExecutor.scheduleJob(this.pollingStrategy, this.cronConfiguration);
            }
        }
        catch (CDCPollingModeException e) {
            this.completionCallback.handle((Throwable)((Object)e));
        }
    }

    public static interface CompletionCallback {
        public void handle(Throwable var1);
    }
}

