/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.polling.strategies;

import com.zaxxer.hikari.HikariDataSource;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.extension.io.cdc.source.config.CronConfiguration;
import io.siddhi.extension.io.cdc.source.metrics.CDCStatus;
import io.siddhi.extension.io.cdc.source.metrics.PollingMetrics;
import io.siddhi.extension.io.cdc.source.polling.CDCPollingModeException;
import io.siddhi.extension.io.cdc.source.polling.strategies.PollingStrategy;
import io.siddhi.extension.io.cdc.util.CDCPollingUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DefaultPollingStrategy
extends PollingStrategy {
    private static final Logger log = Logger.getLogger(DefaultPollingStrategy.class);
    private String pollingColumn;
    private int pollingInterval;
    private String lastReadPollingColumnValue;
    private final CronConfiguration cronConfiguration;
    private int eventsPerPollingInterval;

    public DefaultPollingStrategy(HikariDataSource dataSource, ConfigReader configReader, SourceEventListener sourceEventListener, String tableName, String pollingColumn, int pollingInterval, String appName, PollingMetrics pollingMetrics, CronConfiguration cronConfiguration) {
        super(dataSource, configReader, sourceEventListener, tableName, appName, pollingMetrics);
        this.pollingColumn = pollingColumn;
        this.pollingInterval = pollingInterval;
        this.cronConfiguration = cronConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void poll() {
        block16: {
            Connection connection = this.getConnection();
            try {
                this.lastReadPollingColumnValue = this.getLastReadPollingColumnValue(connection);
                if (this.cronConfiguration.getCronExpression() != null) {
                    this.printEvent(connection);
                    break block16;
                }
                while (true) {
                    if (this.paused) {
                        this.pauseLock.lock();
                        try {
                            while (this.paused) {
                                this.pauseLockCondition.await();
                            }
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        finally {
                            this.pauseLock.unlock();
                        }
                    }
                    long startedTime = System.currentTimeMillis();
                    this.eventsPerPollingInterval = 0;
                    boolean isError = this.printEvent(connection);
                    try {
                        if (this.metrics != null) {
                            this.metrics.setReceiveEventsPerPollingInterval(this.eventsPerPollingInterval);
                            CDCStatus cdcStatus = isError ? CDCStatus.ERROR : CDCStatus.SUCCESS;
                            this.metrics.pollingDetailsMetric(this.eventsPerPollingInterval, startedTime, System.currentTimeMillis() - startedTime, cdcStatus);
                        }
                        Thread.sleep((long)this.pollingInterval * 1000L);
                    }
                    catch (InterruptedException e) {
                        if (this.metrics != null) {
                            this.metrics.setCDCStatus(CDCStatus.ERROR);
                        }
                        log.error((Object)this.buildError("Error while polling the table %s.", this.tableName), (Throwable)e);
                    }
                }
            }
            finally {
                CDCPollingUtil.cleanupConnection(null, null, connection);
            }
        }
    }

    public String getLastReadPollingColumnValue(Connection connection) {
        ResultSet resultSet = null;
        try {
            if (this.lastReadPollingColumnValue == null) {
                String selectQuery = this.getSelectQuery("MAX(" + this.pollingColumn + ")", "").trim();
                PreparedStatement statement = connection.prepareStatement(selectQuery);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    this.lastReadPollingColumnValue = resultSet.getString(1);
                }
                if (this.lastReadPollingColumnValue == null) {
                    this.lastReadPollingColumnValue = "-1";
                }
            }
            String string = this.lastReadPollingColumnValue;
            return string;
        }
        catch (SQLException ex) {
            throw new CDCPollingModeException(this.buildError("Error in polling for changes on %s.", this.tableName), ex);
        }
        finally {
            CDCPollingUtil.cleanupConnection(resultSet, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean printEvent(Connection connection) {
        ResultSet resultSet = null;
        boolean isError = false;
        try {
            String selectQuery = this.getSelectQuery("*", "WHERE " + this.pollingColumn + " > ?");
            PreparedStatement statement = connection.prepareStatement(selectQuery);
            statement.setString(1, this.lastReadPollingColumnValue);
            resultSet = statement.executeQuery();
            ResultSetMetaData metadata = resultSet.getMetaData();
            while (resultSet.next()) {
                ++this.eventsPerPollingInterval;
                HashMap<String, Object> detailsMap = new HashMap<String, Object>();
                for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                    String key = metadata.getColumnName(i);
                    Object value = resultSet.getObject(key);
                    detailsMap.put(key.toLowerCase(Locale.ENGLISH), value);
                }
                this.lastReadPollingColumnValue = resultSet.getString(this.pollingColumn);
                this.handleEvent(detailsMap);
            }
            CDCPollingUtil.cleanupConnection(resultSet, null, null);
            return isError;
        }
        catch (SQLException ex) {
            try {
                if (this.metrics != null) {
                    isError = true;
                    this.metrics.setCDCStatus(CDCStatus.ERROR);
                }
                log.error((Object)this.buildError("Error occurred while processing records in table %s.", this.tableName), (Throwable)ex);
            }
            catch (Throwable throwable) {}
        }
        finally {
            CDCPollingUtil.cleanupConnection(resultSet, null, null);
            return isError;
        }
    }

    @Override
    public String getLastReadPollingColumnValue() {
        return this.lastReadPollingColumnValue;
    }

    @Override
    public void setLastReadPollingColumnValue(String lastReadPollingColumnValue) {
        this.lastReadPollingColumnValue = lastReadPollingColumnValue;
    }
}

