/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonDeserializer
implements Deserializer<JsonNode> {
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public JsonNode deserialize(String topic, byte[] bytes) {
        JsonNode data;
        if (bytes == null) {
            return null;
        }
        try {
            data = this.objectMapper.readTree(bytes);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
        return data;
    }
}

