/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.distributed.ConnectProtocolCompatibility;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.runtime.distributed.WorkerCoordinator;
import org.apache.kafka.connect.runtime.distributed.WorkerRebalanceListener;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;

public class WorkerGroupMember {
    private static final String JMX_PREFIX = "kafka.connect";
    private final Logger log;
    private final Time time;
    private final String clientId;
    private final ConsumerNetworkClient client;
    private final Metrics metrics;
    private final Metadata metadata;
    private final long retryBackoffMs;
    private final WorkerCoordinator coordinator;
    private boolean stopped = false;

    public WorkerGroupMember(DistributedConfig config, String restUrl, ConfigBackingStore configStorage, WorkerRebalanceListener listener, Time time, String clientId, LogContext logContext) {
        try {
            this.time = time;
            this.clientId = clientId;
            this.log = logContext.logger(WorkerGroupMember.class);
            String groupId = config.getString("group.id");
            LinkedHashMap<String, String> metricsTags = new LinkedHashMap<String, String>();
            metricsTags.put("client-id", clientId);
            MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS).tags(metricsTags);
            List<MetricsReporter> reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class, Collections.singletonMap("client.id", clientId));
            reporters.add(new JmxReporter(JMX_PREFIX));
            this.metrics = new Metrics(metricConfig, reporters, time);
            this.retryBackoffMs = config.getLong("retry.backoff.ms");
            this.metadata = new Metadata(this.retryBackoffMs, config.getLong("metadata.max.age.ms"), logContext, new ClusterResourceListeners());
            List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(config.getList("bootstrap.servers"), config.getString("client.dns.lookup"));
            this.metadata.bootstrap(addresses, time.milliseconds());
            String metricGrpPrefix = "connect";
            ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder(config, time);
            NetworkClient netClient = new NetworkClient((Selectable)new Selector(config.getLong("connections.max.idle.ms"), this.metrics, time, metricGrpPrefix, channelBuilder, logContext), this.metadata, clientId, 100, (long)config.getLong("reconnect.backoff.ms"), (long)config.getLong("reconnect.backoff.max.ms"), (int)config.getInt("send.buffer.bytes"), (int)config.getInt("receive.buffer.bytes"), (int)config.getInt("request.timeout.ms"), ClientDnsLookup.forConfig(config.getString("client.dns.lookup")), time, true, new ApiVersions(), logContext);
            this.client = new ConsumerNetworkClient(logContext, netClient, this.metadata, time, this.retryBackoffMs, config.getInt("request.timeout.ms"), Integer.MAX_VALUE);
            this.coordinator = new WorkerCoordinator(logContext, this.client, groupId, config.getInt("rebalance.timeout.ms"), config.getInt("session.timeout.ms"), config.getInt("heartbeat.interval.ms"), this.metrics, metricGrpPrefix, this.time, this.retryBackoffMs, restUrl, configStorage, listener, ConnectProtocolCompatibility.compatibility(config.getString("connect.protocol")), config.getInt("scheduled.rebalance.max.delay.ms"));
            AppInfoParser.registerAppInfo(JMX_PREFIX, clientId, this.metrics, time.milliseconds());
            this.log.debug("Connect group member created");
        }
        catch (Throwable t) {
            this.stop(true);
            throw new KafkaException("Failed to construct kafka consumer", t);
        }
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stop(false);
    }

    public void ensureActive() {
        this.coordinator.poll(0L);
    }

    public void poll(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        this.coordinator.poll(timeout);
    }

    public void wakeup() {
        this.client.wakeup();
    }

    public String memberId() {
        return this.coordinator.memberId();
    }

    public void requestRejoin() {
        this.coordinator.requestRejoin();
    }

    public void maybeLeaveGroup() {
        this.coordinator.maybeLeaveGroup();
    }

    public String ownerUrl(String connector) {
        return this.coordinator.ownerUrl(connector);
    }

    public String ownerUrl(ConnectorTaskId task) {
        return this.coordinator.ownerUrl(task);
    }

    public short currentProtocolVersion() {
        return this.coordinator.currentProtocolVersion();
    }

    private void stop(boolean swallowException) {
        this.log.trace("Stopping the Connect group member.");
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        this.stopped = true;
        Utils.closeQuietly(this.coordinator, "coordinator", firstException);
        Utils.closeQuietly(this.metrics, "consumer metrics", firstException);
        Utils.closeQuietly(this.client, "consumer network client", firstException);
        AppInfoParser.unregisterAppInfo(JMX_PREFIX, this.clientId, this.metrics);
        if (firstException.get() != null && !swallowException) {
            throw new KafkaException("Failed to stop the Connect group member", firstException.get());
        }
        this.log.debug("The Connect group member has stopped.");
    }
}

