/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.mongodb.LegacyV1MongoDbSourceInfoStructMaker;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbSourceInfoStructMaker;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.heartbeat.Heartbeat;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;

public class MongoDbConnectorConfig
extends CommonConnectorConfig {
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 0;
    public static final Field HOSTS = Field.create("mongodb.hosts").withDisplayName("Hosts").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(MongoDbConnectorConfig::validateHosts).withDescription("The hostname and port pairs (in the form 'host' or 'host:port') of the MongoDB server(s) in the replica set.");
    public static final Field LOGICAL_NAME = Field.create("mongodb.name").withDisplayName("Namespace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired).withDescription("Unique name that identifies the MongoDB replica set or cluster and all recorded offsets, andthat is used as a prefix for all schemas and topics. Each distinct MongoDB installation should have a separate namespace and monitored by at most one Debezium connector.");
    public static final Field USER = Field.create("mongodb.user").withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Database user for connecting to MongoDB, if necessary.");
    public static final Field PASSWORD = Field.create("mongodb.password").withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password to be used when connecting to MongoDB, if necessary.");
    public static final Field AUTH_SOURCE = Field.create("mongodb.authsource").withDisplayName("Credentials Database").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault("admin").withDescription("Database containing user credentials.");
    public static final Field POLL_INTERVAL_SEC = Field.create("mongodb.poll.interval.sec").withDisplayName("Replica membership poll interval (sec)").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(30).withValidation(Field::isPositiveInteger).withDescription("Frequency in seconds to look for new, removed, or changed replica sets. Defaults to 30 seconds.");
    public static final Field SSL_ENABLED = Field.create("mongodb.ssl.enabled").withDisplayName("Enable SSL connection to MongoDB").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withValidation(Field::isBoolean).withDescription("Should connector use SSL to connect to MongoDB instances");
    public static final Field SSL_ALLOW_INVALID_HOSTNAMES = Field.create("mongodb.ssl.invalid.hostname.allowed").withDisplayName("Allow invalid hostnames for SSL connection").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withValidation(Field::isBoolean).withDescription("Whether invalid host names are allowed when using SSL. If true the connection will not prevent man-in-the-middle attacks");
    public static final Field MAX_COPY_THREADS = Field.create("initial.sync.max.threads").withDisplayName("Maximum number of threads for initial sync").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(1).withValidation(Field::isPositiveInteger).withDescription("Maximum number of threads used to perform an initial sync of the collections in a replica set. Defaults to 1.");
    public static final Field CONNECT_BACKOFF_INITIAL_DELAY_MS = Field.create("connect.backoff.initial.delay.ms").withDisplayName("Initial delay before reconnection (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(TimeUnit.SECONDS.toMillis(1L)).withValidation(Field::isPositiveInteger).withDescription("The initial delay when trying to reconnect to a primary after a connection cannot be made or when no primary is available. Defaults to 1 second (1000 ms).");
    public static final Field CONNECT_BACKOFF_MAX_DELAY_MS = Field.create("connect.backoff.max.delay.ms").withDisplayName("Maximum delay before reconnection (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(TimeUnit.SECONDS.toMillis(120L)).withValidation(Field::isPositiveInteger).withDescription("The maximum delay when trying to reconnect to a primary after a connection cannot be made or when no primary is available. Defaults to 120 second (120,000 ms).");
    public static final Field MAX_FAILED_CONNECTIONS = Field.create("connect.max.attempts").withDisplayName("Connection attempt limit").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(16).withValidation(Field::isPositiveInteger).withDescription("Maximum number of failed connection attempts to a replica set primary before an exception occurs and task is aborted. Defaults to 16, which with the defaults for '" + CONNECT_BACKOFF_INITIAL_DELAY_MS + "' and '" + CONNECT_BACKOFF_MAX_DELAY_MS + "' results in just over 20 minutes of attempts before failing.");
    public static final Field AUTO_DISCOVER_MEMBERS = Field.create("mongodb.members.auto.discover").withDisplayName("Auto-discovery").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withValidation(Field::isBoolean).withDescription("Specifies whether the addresses in 'hosts' are seeds that should be used to discover all members of the cluster or replica set ('true'), or whether the address(es) in 'hosts' should be used as is ('false'). The default is 'true'.");
    public static final Field DATABASE_WHITELIST = Field.create("database.whitelist").withDisplayName("DB Whitelist").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isListOfRegex, MongoDbConnectorConfig::validateDatabaseBlacklist).withDescription("The databases for which changes are to be captured");
    public static final Field DATABASE_BLACKLIST = Field.create("database.blacklist").withDisplayName("DB Blacklist").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isListOfRegex).withDescription("The databases for which changes are to be excluded");
    public static final Field COLLECTION_WHITELIST = Field.create("collection.whitelist").withDisplayName("Collections").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isListOfRegex, MongoDbConnectorConfig::validateCollectionBlacklist).withDescription("The collections for which changes are to be captured");
    public static final Field COLLECTION_BLACKLIST = Field.create("collection.blacklist").withValidation(Field::isListOfRegex).withInvisibleRecommender();
    public static final Field FIELD_BLACKLIST = Field.create("field.blacklist").withDisplayName("Exclude Fields").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("");
    public static final Field FIELD_RENAMES = Field.create("field.renames").withDisplayName("Rename Fields").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("");
    public static final Field SNAPSHOT_MODE = Field.create("snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should always perform an initial sync when required; 'never' to specify the connector should never perform an initial sync ");
    protected static final Field TASK_ID = Field.create("mongodb.task.id").withDescription("Internal use only").withValidation(Field::isInteger).withInvisibleRecommender();
    public static Field.Set ALL_FIELDS;
    protected static Field.Set EXPOSED_FIELDS;
    private final SnapshotMode snapshotMode;

    public MongoDbConnectorConfig(Configuration config) {
        super(config, config.getString(LOGICAL_NAME), 0);
        String snapshotModeValue = config.getString(SNAPSHOT_MODE);
        this.snapshotMode = SnapshotMode.parse(snapshotModeValue, SNAPSHOT_MODE.defaultValueAsString());
    }

    protected static ConfigDef configDef() {
        ConfigDef config = new ConfigDef();
        Field.group(config, "MongoDB", HOSTS, USER, PASSWORD, LOGICAL_NAME, CONNECT_BACKOFF_INITIAL_DELAY_MS, CONNECT_BACKOFF_MAX_DELAY_MS, MAX_FAILED_CONNECTIONS, AUTO_DISCOVER_MEMBERS, SSL_ENABLED, SSL_ALLOW_INVALID_HOSTNAMES, CommonConnectorConfig.SKIPPED_OPERATIONS);
        Field.group(config, "Events", DATABASE_WHITELIST, DATABASE_BLACKLIST, COLLECTION_WHITELIST, COLLECTION_BLACKLIST, FIELD_BLACKLIST, FIELD_RENAMES, CommonConnectorConfig.TOMBSTONES_ON_DELETE, CommonConnectorConfig.SOURCE_STRUCT_MAKER_VERSION, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX);
        Field.group(config, "Connector", MAX_COPY_THREADS, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.SNAPSHOT_DELAY_MS, CommonConnectorConfig.SNAPSHOT_FETCH_SIZE, SNAPSHOT_MODE);
        return config;
    }

    private static int validateHosts(Configuration config, Field field, Field.ValidationOutput problems) {
        String hosts = config.getString(field);
        if (hosts == null) {
            problems.accept(field, hosts, "Host specification is required");
            return 1;
        }
        int count = 0;
        if (ReplicaSets.parse(hosts).all().isEmpty()) {
            problems.accept(field, hosts, "Invalid host specification");
            ++count;
        }
        return count;
    }

    private static int validateCollectionBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        return MongoDbConnectorConfig.validateBlacklistField(config, problems, COLLECTION_WHITELIST, COLLECTION_BLACKLIST);
    }

    private static int validateDatabaseBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        return MongoDbConnectorConfig.validateBlacklistField(config, problems, DATABASE_WHITELIST, DATABASE_BLACKLIST);
    }

    private static int validateBlacklistField(Configuration config, Field.ValidationOutput problems, Field fieldWhitelist, Field fieldBlacklist) {
        String whitelist = config.getString(fieldWhitelist);
        String blacklist = config.getString(fieldBlacklist);
        if (whitelist != null && blacklist != null) {
            problems.accept(fieldBlacklist, blacklist, "Whitelist is already specified");
            return 1;
        }
        return 0;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        switch (version) {
            case V1: {
                return new LegacyV1MongoDbSourceInfoStructMaker(Module.name(), Module.version(), this);
            }
        }
        return new MongoDbSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    @Override
    public String getContextName() {
        return Module.contextName();
    }

    static {
        EXPOSED_FIELDS = ALL_FIELDS = Field.setOf(USER, PASSWORD, HOSTS, LOGICAL_NAME, SSL_ENABLED, SSL_ALLOW_INVALID_HOSTNAMES, MAX_COPY_THREADS, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.POLL_INTERVAL_MS, MAX_FAILED_CONNECTIONS, CONNECT_BACKOFF_INITIAL_DELAY_MS, CONNECT_BACKOFF_MAX_DELAY_MS, COLLECTION_WHITELIST, COLLECTION_BLACKLIST, FIELD_BLACKLIST, FIELD_RENAMES, AUTO_DISCOVER_MEMBERS, DATABASE_WHITELIST, DATABASE_BLACKLIST, CommonConnectorConfig.TOMBSTONES_ON_DELETE, CommonConnectorConfig.SNAPSHOT_DELAY_MS, CommonConnectorConfig.SNAPSHOT_FETCH_SIZE, SNAPSHOT_MODE, CommonConnectorConfig.SOURCE_STRUCT_MAKER_VERSION, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, CommonConnectorConfig.SKIPPED_OPERATIONS);
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        NEVER("never", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

