/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.ReplicaSetStatus;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.MongoUtil;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.util.Strings;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ReplicaSetDiscovery {
    public static final String CONFIG_DATABASE_NAME = "config";
    public static final String ADMIN_DATABASE_NAME = "admin";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MongoDbTaskContext context;
    private final String seedAddresses;

    public ReplicaSetDiscovery(MongoDbTaskContext context) {
        this.context = context;
        this.seedAddresses = context.getConnectionContext().hosts();
    }

    public ReplicaSets getReplicaSets() {
        MongoClient client = this.context.getConnectionContext().clientFor(this.seedAddresses);
        HashSet<ReplicaSet> replicaSetSpecs = new HashSet<ReplicaSet>();
        String shardsCollection = "shards";
        try {
            MongoUtil.onCollectionDocuments(client, CONFIG_DATABASE_NAME, shardsCollection, doc -> {
                this.logger.info("Checking shard details from configuration replica set {}", (Object)this.seedAddresses);
                String shardName = doc.getString((Object)"_id");
                String hostStr = doc.getString((Object)"host");
                String replicaSetName = MongoUtil.replicaSetUsedIn(hostStr);
                replicaSetSpecs.add(new ReplicaSet(hostStr, replicaSetName, shardName));
            });
        }
        catch (MongoInterruptedException e) {
            this.logger.error("Interrupted while reading the '{}' collection in the '{}' database: {}", new Object[]{shardsCollection, CONFIG_DATABASE_NAME, e.getMessage(), e});
            Thread.currentThread().interrupt();
        }
        catch (MongoException e) {
            this.logger.error("Error while reading the '{}' collection in the '{}' database: {}", new Object[]{shardsCollection, CONFIG_DATABASE_NAME, e.getMessage(), e});
        }
        if (replicaSetSpecs.isEmpty()) {
            ReplicaSetStatus rsStatus = client.getReplicaSetStatus();
            this.logger.info("Checking current members of replica set at {}", (Object)this.seedAddresses);
            if (rsStatus != null) {
                String addressStr = Strings.join((CharSequence)",", client.getServerAddressList());
                String replicaSetName = rsStatus.getName();
                replicaSetSpecs.add(new ReplicaSet(addressStr, replicaSetName, null));
            } else {
                this.logger.debug("Found standalone MongoDB replica set at {}", (Object)this.seedAddresses);
                String replicaSetName = MongoUtil.replicaSetUsedIn(this.seedAddresses);
                if (replicaSetName != null) {
                    for (String address : MongoUtil.ADDRESS_DELIMITER_PATTERN.split(this.seedAddresses)) {
                        replicaSetSpecs.add(new ReplicaSet(address, replicaSetName, null));
                    }
                }
            }
        }
        if (replicaSetSpecs.isEmpty()) {
            this.logger.error("Found no replica sets at {}, so there is nothing to monitor and no connector tasks will be started. Check seed addresses in connector configuration.", (Object)this.seedAddresses);
        }
        return new ReplicaSets(replicaSetSpecs);
    }
}

