/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.mysql.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class MySqlSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = this.commonSchemaBuilder().name("io.debezium.connector.mysql.Source").field("table", Schema.OPTIONAL_STRING_SCHEMA).field("server_id", Schema.INT64_SCHEMA).field("gtid", Schema.OPTIONAL_STRING_SCHEMA).field("file", Schema.STRING_SCHEMA).field("pos", Schema.INT64_SCHEMA).field("row", Schema.INT32_SCHEMA).field("thread", Schema.OPTIONAL_INT64_SCHEMA).field("query", Schema.OPTIONAL_STRING_SCHEMA).build();

    public MySqlSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public Struct struct(SourceInfo sourceInfo) {
        Struct result = this.commonStruct(sourceInfo);
        result.put("server_id", (Object)sourceInfo.getServerId());
        if (sourceInfo.getCurrentGtid() != null) {
            result.put("gtid", (Object)sourceInfo.getCurrentGtid());
        }
        result.put("file", (Object)sourceInfo.getCurrentBinlogFilename());
        result.put("pos", (Object)sourceInfo.getCurrentBinlogPosition());
        result.put("row", (Object)sourceInfo.getCurrentRowNumber());
        if (sourceInfo.getThreadId() >= 0L) {
            result.put("thread", (Object)sourceInfo.getThreadId());
        }
        if (sourceInfo.table() != null) {
            result.put("table", (Object)sourceInfo.table());
        }
        if (sourceInfo.getQuery() != null) {
            result.put("query", (Object)sourceInfo.getQuery());
        }
        return result;
    }
}

