/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr.listener;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.mysql.MySqlDefaultValueConverter;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.ddl.parser.mysql.generated.MySqlParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableEditor;
import io.debezium.relational.ddl.DataType;
import java.util.List;
import java.util.stream.Collectors;

public class ColumnDefinitionParserListener
extends MySqlParserBaseListener {
    private final DataTypeResolver dataTypeResolver;
    private final TableEditor tableEditor;
    private ColumnEditor columnEditor;
    private boolean uniqueColumn;
    private Boolean optionalColumn;
    private final MySqlDefaultValueConverter defaultValueConverter;
    private final boolean convertDefault;

    public ColumnDefinitionParserListener(TableEditor tableEditor, ColumnEditor columnEditor, DataTypeResolver dataTypeResolver, MySqlValueConverters converters, boolean convertDefault) {
        this.tableEditor = tableEditor;
        this.columnEditor = columnEditor;
        this.dataTypeResolver = dataTypeResolver;
        this.convertDefault = convertDefault;
        this.defaultValueConverter = new MySqlDefaultValueConverter(converters);
    }

    public ColumnDefinitionParserListener(TableEditor tableEditor, ColumnEditor columnEditor, DataTypeResolver dataTypeResolver, MySqlValueConverters converters) {
        this(tableEditor, columnEditor, dataTypeResolver, converters, true);
    }

    public void setColumnEditor(ColumnEditor columnEditor) {
        this.columnEditor = columnEditor;
    }

    public ColumnEditor getColumnEditor() {
        return this.columnEditor;
    }

    public Column getColumn() {
        return this.columnEditor.create();
    }

    @Override
    public void enterColumnDefinition(MySqlParser.ColumnDefinitionContext ctx) {
        this.uniqueColumn = false;
        this.optionalColumn = null;
        this.resolveColumnDataType(ctx.dataType());
        super.enterColumnDefinition(ctx);
    }

    @Override
    public void exitColumnDefinition(MySqlParser.ColumnDefinitionContext ctx) {
        if (this.optionalColumn != null) {
            this.columnEditor.optional(this.optionalColumn);
        }
        if (this.uniqueColumn && !this.tableEditor.hasPrimaryKey()) {
            this.tableEditor.addColumn(this.columnEditor.create());
            this.tableEditor.setPrimaryKeyNames(this.columnEditor.name());
        }
        super.exitColumnDefinition(ctx);
    }

    @Override
    public void enterUniqueKeyColumnConstraint(MySqlParser.UniqueKeyColumnConstraintContext ctx) {
        this.uniqueColumn = true;
        super.enterUniqueKeyColumnConstraint(ctx);
    }

    @Override
    public void enterPrimaryKeyColumnConstraint(MySqlParser.PrimaryKeyColumnConstraintContext ctx) {
        this.optionalColumn = Boolean.FALSE;
        this.tableEditor.addColumn(this.columnEditor.create());
        this.tableEditor.setPrimaryKeyNames(this.columnEditor.name());
        super.enterPrimaryKeyColumnConstraint(ctx);
    }

    @Override
    public void enterNullNotnull(MySqlParser.NullNotnullContext ctx) {
        this.optionalColumn = ctx.NOT() == null;
        super.enterNullNotnull(ctx);
    }

    @Override
    public void enterDefaultValue(MySqlParser.DefaultValueContext ctx) {
        String sign = "";
        if (ctx.NULL_LITERAL() != null) {
            return;
        }
        if (ctx.unaryOperator() != null) {
            sign = ctx.unaryOperator().getText();
        }
        if (ctx.constant() != null) {
            if (ctx.constant().stringLiteral() != null) {
                this.columnEditor.defaultValue(sign + this.unquote(ctx.constant().stringLiteral().getText()));
            } else if (ctx.constant().decimalLiteral() != null) {
                this.columnEditor.defaultValue(sign + ctx.constant().decimalLiteral().getText());
            } else if (ctx.constant().BIT_STRING() != null) {
                this.columnEditor.defaultValue(this.unquoteBinary(ctx.constant().BIT_STRING().getText()));
            } else if (ctx.constant().booleanLiteral() != null) {
                this.columnEditor.defaultValue(ctx.constant().booleanLiteral().getText());
            } else if (ctx.constant().REAL_LITERAL() != null) {
                this.columnEditor.defaultValue(ctx.constant().REAL_LITERAL().getText());
            }
        } else if (ctx.currentTimestamp() != null && !ctx.currentTimestamp().isEmpty() && (ctx.currentTimestamp().size() > 1 || ctx.ON() == null && ctx.UPDATE() == null)) {
            MySqlParser.CurrentTimestampContext currentTimestamp = ctx.currentTimestamp(0);
            if (currentTimestamp.CURRENT_TIMESTAMP() != null || currentTimestamp.NOW() != null) {
                this.columnEditor.defaultValue("1970-01-01 00:00:00");
            } else {
                this.columnEditor.defaultValue(currentTimestamp.getText());
            }
        }
        if (this.convertDefault) {
            this.convertDefaultValueToSchemaType(this.columnEditor);
        }
        super.enterDefaultValue(ctx);
    }

    @Override
    public void enterAutoIncrementColumnConstraint(MySqlParser.AutoIncrementColumnConstraintContext ctx) {
        this.columnEditor.autoIncremented(true);
        this.columnEditor.generated(true);
        super.enterAutoIncrementColumnConstraint(ctx);
    }

    @Override
    public void enterSerialDefaultColumnConstraint(MySqlParser.SerialDefaultColumnConstraintContext ctx) {
        this.serialColumn();
        super.enterSerialDefaultColumnConstraint(ctx);
    }

    private void resolveColumnDataType(MySqlParser.DataTypeContext dataTypeContext) {
        String charsetName = null;
        DataType dataType = this.dataTypeResolver.resolveDataType(dataTypeContext);
        if (dataTypeContext instanceof MySqlParser.StringDataTypeContext) {
            MySqlParser.StringDataTypeContext stringDataTypeContext = (MySqlParser.StringDataTypeContext)dataTypeContext;
            if (stringDataTypeContext.lengthOneDimension() != null) {
                Integer length = Integer.valueOf(stringDataTypeContext.lengthOneDimension().decimalLiteral().getText());
                this.columnEditor.length(length);
            }
            if (stringDataTypeContext.charsetName() != null) {
                charsetName = stringDataTypeContext.charsetName().getText();
            }
        } else if (dataTypeContext instanceof MySqlParser.NationalStringDataTypeContext) {
            MySqlParser.NationalStringDataTypeContext nationalStringDataTypeContext = (MySqlParser.NationalStringDataTypeContext)dataTypeContext;
            if (nationalStringDataTypeContext.lengthOneDimension() != null) {
                Integer length = Integer.valueOf(nationalStringDataTypeContext.lengthOneDimension().decimalLiteral().getText());
                this.columnEditor.length(length);
            }
        } else if (dataTypeContext instanceof MySqlParser.NationalVaryingStringDataTypeContext) {
            MySqlParser.NationalVaryingStringDataTypeContext nationalVaryingStringDataTypeContext = (MySqlParser.NationalVaryingStringDataTypeContext)dataTypeContext;
            if (nationalVaryingStringDataTypeContext.lengthOneDimension() != null) {
                Integer length = Integer.valueOf(nationalVaryingStringDataTypeContext.lengthOneDimension().decimalLiteral().getText());
                this.columnEditor.length(length);
            }
        } else if (dataTypeContext instanceof MySqlParser.DimensionDataTypeContext) {
            List<MySqlParser.DecimalLiteralContext> decimalLiterals;
            MySqlParser.DimensionDataTypeContext dimensionDataTypeContext = (MySqlParser.DimensionDataTypeContext)dataTypeContext;
            Integer length = null;
            Integer scale = null;
            if (dimensionDataTypeContext.lengthOneDimension() != null) {
                length = Integer.valueOf(dimensionDataTypeContext.lengthOneDimension().decimalLiteral().getText());
            }
            if (dimensionDataTypeContext.lengthTwoDimension() != null) {
                decimalLiterals = dimensionDataTypeContext.lengthTwoDimension().decimalLiteral();
                length = Integer.valueOf(decimalLiterals.get(0).getText());
                scale = Integer.valueOf(decimalLiterals.get(1).getText());
            }
            if (dimensionDataTypeContext.lengthTwoOptionalDimension() != null) {
                decimalLiterals = dimensionDataTypeContext.lengthTwoOptionalDimension().decimalLiteral();
                length = Integer.valueOf(decimalLiterals.get(0).getText());
                if (decimalLiterals.size() > 1) {
                    scale = Integer.valueOf(decimalLiterals.get(1).getText());
                }
            }
            if (length != null) {
                this.columnEditor.length(length);
            }
            if (scale != null) {
                this.columnEditor.scale(scale);
            }
        } else if (dataTypeContext instanceof MySqlParser.CollectionDataTypeContext) {
            MySqlParser.CollectionDataTypeContext collectionDataTypeContext = (MySqlParser.CollectionDataTypeContext)dataTypeContext;
            if (collectionDataTypeContext.charsetName() != null) {
                charsetName = collectionDataTypeContext.charsetName().getText();
            }
            if (dataType.name().toUpperCase().equals("SET")) {
                int optionsSize = collectionDataTypeContext.collectionOptions().collectionOption().size();
                this.columnEditor.length(Math.max(0, optionsSize * 2 - 1));
            } else {
                this.columnEditor.length(1);
            }
        }
        String dataTypeName = dataType.name().toUpperCase();
        if (dataTypeName.equals("ENUM") || dataTypeName.equals("SET")) {
            MySqlParser.CollectionDataTypeContext collectionDataTypeContext = (MySqlParser.CollectionDataTypeContext)dataTypeContext;
            List<String> collectionOptions = collectionDataTypeContext.collectionOptions().collectionOption().stream().map(AntlrDdlParser::getText).collect(Collectors.toList());
            this.columnEditor.type(dataTypeName);
            this.columnEditor.enumValues(collectionOptions);
        } else if (dataTypeName.equals("SERIAL")) {
            this.columnEditor.type("BIGINT UNSIGNED");
            this.serialColumn();
        } else {
            this.columnEditor.type(dataTypeName);
        }
        int jdbcDataType = dataType.jdbcType();
        this.columnEditor.jdbcType(jdbcDataType);
        if (this.columnEditor.length() == -1) {
            this.columnEditor.length((int)dataType.length());
        }
        if (!this.columnEditor.scale().isPresent() && dataType.scale() != -1) {
            this.columnEditor.scale(dataType.scale());
        }
        if (-15 == jdbcDataType || -9 == jdbcDataType) {
            this.columnEditor.charsetName("utf8");
        } else {
            this.columnEditor.charsetName(charsetName);
        }
    }

    private void serialColumn() {
        if (this.optionalColumn == null) {
            this.optionalColumn = Boolean.FALSE;
        }
        this.uniqueColumn = true;
        this.columnEditor.autoIncremented(true);
        this.columnEditor.generated(true);
    }

    private void convertDefaultValueToSchemaType(ColumnEditor columnEditor) {
        if (this.optionalColumn != null) {
            columnEditor.optional(this.optionalColumn);
        }
        this.defaultValueConverter.setColumnDefaultValue(columnEditor);
    }

    private String unquote(String stringLiteral) {
        return stringLiteral.substring(1, stringLiteral.length() - 1);
    }

    private String unquoteBinary(String stringLiteral) {
        return stringLiteral.substring(2, stringLiteral.length() - 1);
    }
}

