/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.metrics;

import io.siddhi.extension.io.cdc.source.metrics.CDCStatus;
import io.siddhi.extension.io.cdc.source.metrics.Metrics;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

public class PollingMetrics
extends Metrics {
    private static final Logger log = Logger.getLogger(PollingMetrics.class);
    private final Queue<String> pollingDetails = new LinkedList<String>();
    private int receiveEventsPerPollingInterval;
    private int pollingHistorySize;

    public PollingMetrics(String siddhiAppName, String dbURL, String tableName) {
        super(siddhiAppName, dbURL, tableName);
        CDC_STATUS_SERVICE_STARTED_MAP.putIfAbsent(siddhiAppName, false);
    }

    @Override
    public void updateTableStatus(ExecutorService executorService, String siddhiAppName) {
        if (!((Boolean)CDC_STATUS_SERVICE_STARTED_MAP.get(siddhiAppName)).booleanValue()) {
            CDC_STATUS_SERVICE_STARTED_MAP.replace(siddhiAppName, true);
            executorService.execute(() -> {
                while (((Boolean)CDC_STATUS_SERVICE_STARTED_MAP.get(siddhiAppName)).booleanValue()) {
                    if (!CDC_STATUS_MAP.isEmpty()) {
                        CDC_LAST_RECEIVED_TIME_MAP.forEach((cdcDatabase, lastPublishedTime) -> {
                            long idleTime;
                            if (cdcDatabase.siddhiAppName.equals(siddhiAppName) && (idleTime = System.currentTimeMillis() - lastPublishedTime) / 1000L > 8L) {
                                CDC_STATUS_MAP.replace(cdcDatabase, CDCStatus.IDLE);
                            }
                        });
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)(siddhiAppName + ": Error while updating the tables status."));
                    }
                }
            });
        }
    }

    @Override
    public Counter getEventCountMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Polling.event.count.%s.%s.host.%s.%s.%s", this.siddhiAppName, this.dbType, this.host, this.databaseName, this.tableName, this.getDatabaseURL()), Level.INFO, new Level[0]);
    }

    public Counter getValidEventCountMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Polling.%s.%s", this.siddhiAppName, "total_valid_events_count", this.getDatabaseURL()), Level.INFO, new Level[0]);
    }

    public Counter getTotalErrorCountMetric() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Polling.%s.%s", this.siddhiAppName, "total_error_count", this.getDatabaseURL()), Level.INFO, new Level[0]);
    }

    @Override
    protected void lastReceivedTimeMetric() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Polling.%s.%s", this.siddhiAppName, "last_receive_time", this.getDatabaseURL()), Level.INFO, () -> {
            if (CDC_LAST_RECEIVED_TIME_MAP.containsKey(this.cdcDatabase)) {
                return (Long)CDC_LAST_RECEIVED_TIME_MAP.get(this.cdcDatabase);
            }
            return 0L;
        });
    }

    @Override
    protected void idleTimeMetric() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Polling.%s.%s", this.siddhiAppName, "idle_time", this.getDatabaseURL()), Level.INFO, () -> {
            if (CDC_LAST_RECEIVED_TIME_MAP.containsKey(this.cdcDatabase)) {
                return (System.currentTimeMillis() - (Long)CDC_LAST_RECEIVED_TIME_MAP.get(this.cdcDatabase)) / 1000L;
            }
            return 0L;
        });
    }

    @Override
    protected void setCDCDBStatusMetric() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Polling.%s.%s", this.siddhiAppName, "db_status", this.getDatabaseURL()), Level.INFO, () -> {
            if (CDC_STATUS_MAP.containsKey(this.cdcDatabase)) {
                return ((CDCStatus)((Object)((Object)CDC_STATUS_MAP.get(this.cdcDatabase)))).ordinal();
            }
            return -1;
        });
    }

    private void setEventsInLastPollingMetric() {
        MetricsDataHolder.getInstance().getMetricService().gauge(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Polling.%s.%s", this.siddhiAppName, "events_in_last_polling_interval", this.getDatabaseURL()), Level.INFO, () -> this.receiveEventsPerPollingInterval);
    }

    public void pollingDetailsMetric(int events, long startedTime, long duration, CDCStatus cdcStatus) {
        String metricName = String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc.Source.Polling.Details.%s.%s.%s.%s", this.siddhiAppName, startedTime, duration, cdcStatus.ordinal(), this.getDatabaseURL());
        MetricsDataHolder.getInstance().getMetricService().gauge(metricName, Level.INFO, () -> events);
        this.pollingDetails.add(metricName);
        if (this.pollingDetails.size() > this.pollingHistorySize) {
            String poll = this.pollingDetails.poll();
            MetricsDataHolder.getInstance().getMetricService().remove(poll);
        }
    }

    @Override
    public synchronized void setCDCStatus(CDCStatus cdcStatus) {
        if (cdcStatus == CDCStatus.ERROR) {
            this.getTotalErrorCountMetric().inc();
        }
        if (CDC_STATUS_MAP.containsKey(this.cdcDatabase)) {
            CDC_STATUS_MAP.replace(this.cdcDatabase, cdcStatus);
        } else {
            CDC_STATUS_MAP.put(this.cdcDatabase, cdcStatus);
            this.setCDCDBStatusMetric();
        }
    }

    @Override
    public synchronized void setLastReceivedTime(long lastPublishedTime) {
        if (CDC_LAST_RECEIVED_TIME_MAP.containsKey(this.cdcDatabase)) {
            if ((Long)CDC_LAST_RECEIVED_TIME_MAP.get(this.cdcDatabase) < lastPublishedTime) {
                CDC_LAST_RECEIVED_TIME_MAP.replace(this.cdcDatabase, lastPublishedTime);
            }
        } else {
            CDC_LAST_RECEIVED_TIME_MAP.put(this.cdcDatabase, lastPublishedTime);
            this.lastReceivedTimeMetric();
            this.setEventsInLastPollingMetric();
            this.idleTimeMetric();
        }
    }

    @Override
    protected String getDatabaseURL() {
        return this.host + "/" + this.tableName;
    }

    public void setReceiveEventsPerPollingInterval(int receiveEventsPerPollingInterval) {
        this.receiveEventsPerPollingInterval = receiveEventsPerPollingInterval;
    }

    public void setPollingHistorySize(int pollingHistorySize) {
        this.pollingHistorySize = pollingHistorySize;
    }
}

