/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSetOffsetContext;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.schema.DataCollectionId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.bson.Document;

public class MongoDbOffsetContext
implements OffsetContext {
    private final SourceInfo sourceInfo;
    private final TransactionContext transactionContext;
    private final Map<ReplicaSet, ReplicaSetOffsetContext> replicaSetOffsetContexts = new ConcurrentHashMap<ReplicaSet, ReplicaSetOffsetContext>();

    public MongoDbOffsetContext(SourceInfo sourceInfo, TransactionContext transactionContext) {
        this.sourceInfo = sourceInfo;
        this.transactionContext = transactionContext;
    }

    public MongoDbOffsetContext(SourceInfo sourceInfo, TransactionContext transactionContext, Map<ReplicaSet, Document> offsets) {
        this(sourceInfo, transactionContext);
        offsets.forEach((replicaSet, document) -> sourceInfo.opLogEvent(replicaSet.replicaSetName(), (Document)document, (Document)document, 0L));
    }

    void startReplicaSetSnapshot(String replicaSetName) {
        this.sourceInfo.startInitialSync(replicaSetName);
    }

    void stopReplicaSetSnapshot(String replicaSetName) {
        this.sourceInfo.stopInitialSync(replicaSetName);
    }

    @Override
    public Map<String, ?> getPartition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, ?> getOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Schema getSourceInfoSchema() {
        return this.sourceInfo.schema();
    }

    @Override
    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    @Override
    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && this.sourceInfo.isSnapshotRunning();
    }

    @Override
    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(SnapshotRecord.TRUE);
    }

    @Override
    public void preSnapshotCompletion() {
    }

    @Override
    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(SnapshotRecord.FALSE);
    }

    @Override
    public void markLastSnapshotRecord() {
        this.sourceInfo.setSnapshot(SnapshotRecord.LAST);
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public void event(DataCollectionId collectionId, Instant timestamp) {
        throw new UnsupportedOperationException();
    }

    public ReplicaSetOffsetContext getReplicaSetOffsetContext(ReplicaSet replicaSet) {
        return this.replicaSetOffsetContexts.computeIfAbsent(replicaSet, rs -> new ReplicaSetOffsetContext(this, (ReplicaSet)rs, this.sourceInfo));
    }

    public String toString() {
        return "MongoDbOffsetContext [sourceInfo=" + this.sourceInfo + "]";
    }

    public static class Loader {
        private final ReplicaSets replicaSets;
        private final SourceInfo sourceInfo;

        public Loader(MongoDbConnectorConfig connectorConfig, ReplicaSets replicaSets) {
            this.sourceInfo = new SourceInfo(connectorConfig);
            this.replicaSets = replicaSets;
        }

        public Collection<Map<String, String>> getPartitions() {
            ArrayList<Map<String, String>> partitions = new ArrayList<Map<String, String>>();
            this.replicaSets.onEachReplicaSet(replicaSet -> {
                String name = replicaSet.replicaSetName();
                if (name != null) {
                    Map<String, String> partition = this.sourceInfo.partition(name);
                    partitions.add(partition);
                }
            });
            return partitions;
        }

        public MongoDbOffsetContext loadOffsets(Map<Map<String, String>, Map<String, Object>> offsets) {
            offsets.forEach(this.sourceInfo::setOffsetFor);
            return new MongoDbOffsetContext(this.sourceInfo, new TransactionContext());
        }
    }
}

