/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.util.SchemaNameAdjuster;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class MongoDbSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = this.commonSchemaBuilder().name(SchemaNameAdjuster.defaultAdjuster().adjust("io.debezium.connector.mongo.Source")).field("rs", Schema.STRING_SCHEMA).field("collection", Schema.STRING_SCHEMA).field("ord", Schema.INT32_SCHEMA).field("h", Schema.OPTIONAL_INT64_SCHEMA).field("tord", Schema.OPTIONAL_INT64_SCHEMA).build();

    public MongoDbSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public Struct struct(SourceInfo sourceInfo) {
        Struct struct = super.commonStruct(sourceInfo).put("rs", (Object)sourceInfo.replicaSetName()).put("collection", (Object)sourceInfo.collectionId().name()).put("ord", (Object)sourceInfo.position().getInc()).put("h", (Object)sourceInfo.position().getOperationId());
        sourceInfo.transactionPosition().ifPresent(transactionPosition -> struct.put("tord", (Object)transactionPosition));
        return struct;
    }
}

