/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.transforms.MongoDataConverter;
import io.debezium.data.Envelope;
import io.debezium.schema.FieldNameSelector;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import io.debezium.transforms.SmtManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Flatten;
import org.apache.kafka.connect.transforms.Transformation;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractNewDocumentState<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractNewDocumentState.class);
    private static final Field ARRAY_ENCODING = Field.create("array.encoding").withDisplayName("Array encoding").withEnum(ArrayEncoding.class, ArrayEncoding.ARRAY).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The arrays can be encoded using 'array' schema type (the default) or as a 'document' (similar to how BSON encodes arrays). 'array' is easier to consume but requires all elements in the array to be of the same type. Use 'document' if the arrays in data source mix different types together.");
    private static final Field FLATTEN_STRUCT = Field.create("flatten.struct").withDisplayName("Flatten struct").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Flattening structs by concatenating the fields into plain properties, using a (configurable) delimiter.");
    private static final Field DELIMITER = Field.create("flatten.struct.delimiter").withDisplayName("Delimiter for flattened struct").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault("_").withDescription("Delimiter to concat between field names from the input record when generating field names for theoutput record.");
    public static final Field SANITIZE_FIELD_NAMES = Field.create("sanitize.field.names").withDisplayName("Sanitize field names to adhere to Avro naming conventions").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Whether field names will be sanitized to Avro naming conventions").withDefault(Boolean.FALSE);
    private final ExtractField<R> afterExtractor = new ExtractField.Value();
    private final ExtractField<R> patchExtractor = new ExtractField.Value();
    private final ExtractField<R> keyExtractor = new ExtractField.Key();
    private MongoDataConverter converter;
    private final Flatten<R> recordFlattener = new Flatten.Value();
    private boolean addOperationHeader;
    private String[] addSourceFields;
    private boolean flattenStruct;
    private String delimiter;
    private boolean dropTombstones;
    private ExtractNewRecordStateConfigDefinition.DeleteHandling handleDeletes;
    private SmtManager<R> smtManager;

    @Override
    public R apply(R record) {
        if (!this.smtManager.isValidKey(record)) {
            return record;
        }
        R keyRecord = this.keyExtractor.apply(record);
        BsonDocument keyDocument = BsonDocument.parse((String)("{ \"id\" : " + ((ConnectRecord)keyRecord).key().toString() + "}"));
        BsonDocument valueDocument = new BsonDocument();
        if (((ConnectRecord)record).value() == null) {
            if (this.dropTombstones) {
                LOGGER.trace("Tombstone {} arrived and requested to be dropped", ((ConnectRecord)record).key());
                return null;
            }
            if (this.addOperationHeader) {
                ((ConnectRecord)record).headers().addString("__debezium-operation", Envelope.Operation.DELETE.code());
            }
            return this.newRecord(record, keyDocument, valueDocument);
        }
        if (!this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        R afterRecord = this.afterExtractor.apply(record);
        R patchRecord = this.patchExtractor.apply(record);
        if (this.addOperationHeader) {
            ((ConnectRecord)record).headers().addString("__debezium-operation", ((Struct)((ConnectRecord)record).value()).get("op").toString());
        }
        if (((ConnectRecord)afterRecord).value() != null) {
            valueDocument = this.getInsertDocument(afterRecord, keyDocument);
        }
        if (((ConnectRecord)afterRecord).value() == null && ((ConnectRecord)patchRecord).value() != null) {
            valueDocument = this.getUpdateDocument(patchRecord, keyDocument);
        }
        boolean isDeletion = false;
        if (((ConnectRecord)afterRecord).value() == null && ((ConnectRecord)patchRecord).value() == null) {
            if (this.handleDeletes.equals(ExtractNewRecordStateConfigDefinition.DeleteHandling.DROP)) {
                LOGGER.trace("Delete {} arrived and requested to be dropped", ((ConnectRecord)record).key());
                return null;
            }
            isDeletion = true;
        }
        if (this.handleDeletes.equals(ExtractNewRecordStateConfigDefinition.DeleteHandling.REWRITE)) {
            valueDocument.append("__deleted", (BsonValue)new BsonBoolean(isDeletion));
        }
        return this.newRecord(record, keyDocument, valueDocument);
    }

    private R newRecord(R record, BsonDocument keyDocument, BsonDocument valueDocument) {
        SchemaBuilder keySchemaBuilder = SchemaBuilder.struct();
        Set keyPairs = keyDocument.entrySet();
        for (Map.Entry keyPairsForSchema : keyPairs) {
            this.converter.addFieldSchema(keyPairsForSchema, keySchemaBuilder);
        }
        Schema finalKeySchema = keySchemaBuilder.build();
        Struct finalKeyStruct = new Struct(finalKeySchema);
        for (Map.Entry keyPairsForStruct : keyPairs) {
            this.converter.convertRecord(keyPairsForStruct, finalKeySchema, finalKeyStruct);
        }
        Schema finalValueSchema = null;
        Struct finalValueStruct = null;
        if (valueDocument.size() > 0) {
            BsonDocument val1;
            String newValueSchemaName = ((ConnectRecord)record).valueSchema().name();
            if (Envelope.isEnvelopeSchema(newValueSchemaName)) {
                newValueSchemaName = newValueSchemaName.substring(0, newValueSchemaName.length() - 9);
            }
            SchemaBuilder valueSchemaBuilder = SchemaBuilder.struct().name(newValueSchemaName);
            Set valuePairs = valueDocument.entrySet();
            for (Map.Entry valuePairsForSchema : valuePairs) {
                if (((String)valuePairsForSchema.getKey()).equalsIgnoreCase("$set")) {
                    val1 = BsonDocument.parse((String)((BsonValue)valuePairsForSchema.getValue()).toString());
                    Set keyValuesForSetSchema = val1.entrySet();
                    for (Map.Entry keyValuesForSetSchemaEntry : keyValuesForSetSchema) {
                        this.converter.addFieldSchema(keyValuesForSetSchemaEntry, valueSchemaBuilder);
                    }
                    continue;
                }
                this.converter.addFieldSchema(valuePairsForSchema, valueSchemaBuilder);
            }
            if (this.addSourceFields != null) {
                this.addSourceFieldsSchema(this.addSourceFields, record, valueSchemaBuilder);
            }
            finalValueSchema = valueSchemaBuilder.build();
            finalValueStruct = new Struct(finalValueSchema);
            for (Map.Entry valuePairsForStruct : valuePairs) {
                if (((String)valuePairsForStruct.getKey()).equalsIgnoreCase("$set")) {
                    val1 = BsonDocument.parse((String)((BsonValue)valuePairsForStruct.getValue()).toString());
                    Set keyValueForSetStruct = val1.entrySet();
                    for (Map.Entry keyValueForSetStructEntry : keyValueForSetStruct) {
                        this.converter.convertRecord(keyValueForSetStructEntry, finalValueSchema, finalValueStruct);
                    }
                    continue;
                }
                this.converter.convertRecord(valuePairsForStruct, finalValueSchema, finalValueStruct);
            }
            if (this.addSourceFields != null) {
                this.addSourceFieldsValue(this.addSourceFields, record, finalValueStruct);
            }
        }
        Object newRecord = ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), finalKeySchema, finalKeyStruct, finalValueSchema, finalValueStruct, ((ConnectRecord)record).timestamp());
        if (this.flattenStruct) {
            return this.recordFlattener.apply(newRecord);
        }
        return newRecord;
    }

    private void addSourceFieldsSchema(String[] addSourceFields, R originalRecord, SchemaBuilder valueSchemaBuilder) {
        Schema sourceSchema = ((ConnectRecord)originalRecord).valueSchema().field("source").schema();
        for (String sourceField : addSourceFields) {
            if (sourceSchema.field(sourceField) == null) {
                throw new ConfigException("Source field specified in 'add.source.fields' does not exist: " + sourceField);
            }
            valueSchemaBuilder.field("__" + sourceField, sourceSchema.field(sourceField).schema());
        }
    }

    private void addSourceFieldsValue(String[] addSourceFields, R originalRecord, Struct valueStruct) {
        Struct sourceValue = ((Struct)((ConnectRecord)originalRecord).value()).getStruct("source");
        for (String sourceField : addSourceFields) {
            valueStruct.put("__" + sourceField, sourceValue.get(sourceField));
        }
    }

    private BsonDocument getUpdateDocument(R patchRecord, BsonDocument keyDocument) {
        BsonDocument valueDocument = new BsonDocument();
        BsonDocument document = BsonDocument.parse((String)((ConnectRecord)patchRecord).value().toString());
        if (document.containsKey((Object)"$set")) {
            valueDocument = document.getDocument((Object)"$set");
        }
        if (document.containsKey((Object)"$unset")) {
            Set unsetDocumentEntry = document.getDocument((Object)"$unset").entrySet();
            for (Map.Entry valueEntry : unsetDocumentEntry) {
                if (!((BsonValue)valueEntry.getValue()).asBoolean().getValue()) continue;
                valueDocument.append((String)valueEntry.getKey(), (BsonValue)new BsonNull());
            }
        }
        if (!document.containsKey((Object)"$set") && !document.containsKey((Object)"$unset")) {
            if (!document.containsKey((Object)"_id")) {
                throw new ConnectException("Unable to process Mongo Operation, a '$set' or '$unset' is necessary for partial updates or '_id' is expected for full Document replaces.");
            }
            valueDocument = document;
            valueDocument.remove((Object)"_id");
        }
        if (!valueDocument.containsKey((Object)"id")) {
            valueDocument.append("id", keyDocument.get((Object)"id"));
        }
        if (this.flattenStruct) {
            BsonDocument newDocument = new BsonDocument();
            valueDocument.forEach((fKey, fValue) -> newDocument.put(fKey.replace(".", this.delimiter), fValue));
            valueDocument = newDocument;
        }
        return valueDocument;
    }

    private BsonDocument getInsertDocument(R record, BsonDocument key) {
        BsonDocument valueDocument = BsonDocument.parse((String)((ConnectRecord)record).value().toString());
        valueDocument.remove((Object)"_id");
        valueDocument.append("id", key.get((Object)"id"));
        return valueDocument;
    }

    @Override
    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, ARRAY_ENCODING, FLATTEN_STRUCT, DELIMITER, SANITIZE_FIELD_NAMES);
        return config;
    }

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> map) {
        Configuration config = Configuration.from(map);
        this.smtManager = new SmtManager(config);
        Field.Set configFields = Field.setOf(ARRAY_ENCODING, FLATTEN_STRUCT, DELIMITER, ExtractNewRecordStateConfigDefinition.OPERATION_HEADER, ExtractNewRecordStateConfigDefinition.HANDLE_DELETES, ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES, SANITIZE_FIELD_NAMES);
        if (!config.validateAndRecord(configFields, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Unable to validate config.");
        }
        this.converter = new MongoDataConverter(ArrayEncoding.parse(config.getString(ARRAY_ENCODING)), FieldNameSelector.defaultNonRelationalSelector(config.getBoolean(SANITIZE_FIELD_NAMES)));
        this.addOperationHeader = config.getBoolean(ExtractNewRecordStateConfigDefinition.OPERATION_HEADER);
        this.addSourceFields = config.getString(ExtractNewRecordStateConfigDefinition.ADD_SOURCE_FIELDS).isEmpty() ? null : config.getString(ExtractNewRecordStateConfigDefinition.ADD_SOURCE_FIELDS).split(",");
        this.flattenStruct = config.getBoolean(FLATTEN_STRUCT);
        this.delimiter = config.getString(DELIMITER);
        this.dropTombstones = config.getBoolean(ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES);
        this.handleDeletes = ExtractNewRecordStateConfigDefinition.DeleteHandling.parse(config.getString(ExtractNewRecordStateConfigDefinition.HANDLE_DELETES));
        HashMap<String, String> afterExtractorConfig = new HashMap<String, String>();
        afterExtractorConfig.put("field", "after");
        HashMap<String, String> patchExtractorConfig = new HashMap<String, String>();
        patchExtractorConfig.put("field", "patch");
        HashMap<String, String> keyExtractorConfig = new HashMap<String, String>();
        keyExtractorConfig.put("field", "id");
        this.afterExtractor.configure(afterExtractorConfig);
        this.patchExtractor.configure(patchExtractorConfig);
        this.keyExtractor.configure(keyExtractorConfig);
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("delimiter", this.delimiter);
        this.recordFlattener.configure(delegateConfig);
    }

    public static enum ArrayEncoding implements EnumeratedValue
    {
        ARRAY("array"),
        DOCUMENT("document");

        private final String value;

        private ArrayEncoding(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static ArrayEncoding parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (ArrayEncoding option : ArrayEncoding.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static ArrayEncoding parse(String value, String defaultValue) {
            ArrayEncoding mode = ArrayEncoding.parse(value);
            if (mode == null && defaultValue != null) {
                mode = ArrayEncoding.parse(defaultValue);
            }
            return mode;
        }
    }
}

