/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.LegacyV1AbstractSourceInfoStructMaker;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.postgresql.SourceInfo;
import io.debezium.time.Conversions;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class LegacyV1PostgresSourceInfoStructMaker
extends LegacyV1AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = this.commonSchemaBuilder().name("io.debezium.connector.postgresql.Source").field("name", Schema.STRING_SCHEMA).field("db", Schema.STRING_SCHEMA).field("ts_usec", Schema.OPTIONAL_INT64_SCHEMA).field("txId", Schema.OPTIONAL_INT64_SCHEMA).field("lsn", Schema.OPTIONAL_INT64_SCHEMA).field("schema", Schema.OPTIONAL_STRING_SCHEMA).field("table", Schema.OPTIONAL_STRING_SCHEMA).field("snapshot", SchemaBuilder.bool().optional().defaultValue(false).build()).field("last_snapshot_record", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("xmin", Schema.OPTIONAL_INT64_SCHEMA).build();
    private final String serverName;

    public LegacyV1PostgresSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
        this.serverName = connectorConfig.getLogicalName();
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public Struct struct(SourceInfo sourceInfo) {
        assert (sourceInfo.database() != null && sourceInfo.schemaName() != null && sourceInfo.tableName() != null);
        Struct result = super.commonStruct();
        result.put("name", (Object)this.serverName);
        result.put("db", (Object)sourceInfo.database());
        result.put("schema", (Object)sourceInfo.schemaName());
        result.put("table", (Object)sourceInfo.tableName());
        if (sourceInfo.timestamp() != null) {
            result.put("ts_usec", (Object)Conversions.toEpochMicros(sourceInfo.timestamp()));
        }
        if (sourceInfo.txId() != null) {
            result.put("txId", (Object)sourceInfo.txId());
        }
        if (sourceInfo.lsn() != null) {
            result.put("lsn", (Object)sourceInfo.lsn());
        }
        if (sourceInfo.xmin() != null) {
            result.put("xmin", (Object)sourceInfo.xmin());
        }
        if (sourceInfo.isSnapshot()) {
            result.put("snapshot", (Object)true);
            result.put("last_snapshot_record", (Object)(sourceInfo.snapshot() == SnapshotRecord.LAST ? 1 : 0));
        }
        return result;
    }
}

