/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.wal2json;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.AbstractReplicationMessageColumn;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.connection.ReplicationMessageColumnValueResolver;
import io.debezium.connector.postgresql.connection.wal2json.Wal2JsonColumnValue;
import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.document.Value;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Wal2JsonReplicationMessage
implements ReplicationMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(Wal2JsonReplicationMessage.class);
    private final long txId;
    private final Instant commitTime;
    private final Document rawMessage;
    private final boolean hasMetadata;
    private final boolean lastEventForLsn;
    private final TypeRegistry typeRegistry;

    public Wal2JsonReplicationMessage(long txId, Instant commitTime, Document rawMessage, boolean hasMetadata, boolean lastEventForLsn, TypeRegistry typeRegistry) {
        this.txId = txId;
        this.commitTime = commitTime;
        this.rawMessage = rawMessage;
        this.hasMetadata = hasMetadata;
        this.lastEventForLsn = lastEventForLsn;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public ReplicationMessage.Operation getOperation() {
        String operation;
        switch (operation = this.rawMessage.getString("kind")) {
            case "insert": {
                return ReplicationMessage.Operation.INSERT;
            }
            case "update": {
                return ReplicationMessage.Operation.UPDATE;
            }
            case "delete": {
                return ReplicationMessage.Operation.DELETE;
            }
        }
        throw new IllegalArgumentException("Unknown operation '" + operation + "' in replication stream message");
    }

    @Override
    public Instant getCommitTime() {
        return this.commitTime;
    }

    @Override
    public long getTransactionId() {
        return this.txId;
    }

    @Override
    public String getTable() {
        return "\"" + this.rawMessage.getString("schema") + "\".\"" + this.rawMessage.getString("table") + "\"";
    }

    @Override
    public List<ReplicationMessage.Column> getOldTupleList() {
        Document oldkeys = this.rawMessage.getDocument("oldkeys");
        return oldkeys != null ? this.transform(oldkeys, "keynames", "keytypes", "keyvalues", "columnoptionals") : null;
    }

    @Override
    public List<ReplicationMessage.Column> getNewTupleList() {
        return this.transform(this.rawMessage, "columnnames", "columntypes", "columnvalues", "columnoptionals");
    }

    @Override
    public boolean hasTypeMetadata() {
        return this.hasMetadata;
    }

    private List<ReplicationMessage.Column> transform(Document data, String nameField, String typeField, String valueField, String optionalsField) {
        Array columnNames = data.getArray(nameField);
        Array columnTypes = data.getArray(typeField);
        Array columnValues = data.getArray(valueField);
        Array columnOptionals = data.getArray(optionalsField);
        if (columnNames.size() != columnTypes.size() || columnNames.size() != columnValues.size()) {
            throw new ConnectException("Column related arrays do not have the same size");
        }
        ArrayList<ReplicationMessage.Column> columns = new ArrayList<ReplicationMessage.Column>(columnNames.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            final String columnName = columnNames.get(i).asString();
            final String columnTypeName = columnTypes.get(i).asString();
            boolean columnOptional = columnOptionals != null ? columnOptionals.get(i).asBoolean() : false;
            final Value rawValue = columnValues.get(i);
            final PostgresType columnType = this.typeRegistry.get(this.parseType(columnName, columnTypeName));
            columns.add(new AbstractReplicationMessageColumn(columnName, columnType, columnTypeName, columnOptional, true){

                @Override
                public Object getValue(PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
                    return Wal2JsonReplicationMessage.this.getValue(columnName, columnType, columnTypeName, rawValue, connection, includeUnknownDatatypes);
                }

                public String toString() {
                    return columnName + "(" + columnTypeName + ")=" + rawValue;
                }
            });
        }
        return columns;
    }

    private String parseType(String columnName, String typeWithModifiers) {
        Matcher m = AbstractReplicationMessageColumn.TypeMetadataImpl.TYPE_PATTERN.matcher(typeWithModifiers);
        if (!m.matches()) {
            LOGGER.error("Failed to parse columnType for {} '{}'", (Object)columnName, (Object)typeWithModifiers);
            throw new ConnectException(String.format("Failed to parse columnType '%s' for column %s", typeWithModifiers, columnName));
        }
        String baseType = m.group("base").trim();
        String suffix = m.group("suffix");
        if (suffix != null) {
            baseType = baseType + suffix;
        }
        baseType = TypeRegistry.normalizeTypeName(baseType);
        if (m.group("array") != null) {
            baseType = "_" + baseType;
        }
        return baseType;
    }

    public Object getValue(String columnName, PostgresType type, String fullType, Value rawValue, PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
        Wal2JsonColumnValue columnValue = new Wal2JsonColumnValue(rawValue);
        return ReplicationMessageColumnValueResolver.resolveValue(columnName, type, fullType, columnValue, connection, includeUnknownDatatypes, this.typeRegistry);
    }

    @Override
    public boolean isLastEventForLsn() {
        return this.lastEventForLsn;
    }
}

