/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.config.Configuration;
import io.debezium.data.Envelope;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtManager<R extends ConnectRecord<R>> {
    private static final String RECORD_ENVELOPE_KEY_SCHEMA_NAME_SUFFIX = ".Key";
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtManager.class);

    public SmtManager(Configuration config) {
    }

    public boolean isValidEnvelope(R record) {
        if (((ConnectRecord)record).valueSchema() == null || ((ConnectRecord)record).valueSchema().name() == null || !Envelope.isEnvelopeSchema(((ConnectRecord)record).valueSchema())) {
            LOGGER.warn("Expected Envelope for transformation, passing it unchanged");
            return false;
        }
        return true;
    }

    public boolean isValidKey(R record) {
        if (((ConnectRecord)record).keySchema() == null || ((ConnectRecord)record).keySchema().name() == null || !((ConnectRecord)record).keySchema().name().endsWith(RECORD_ENVELOPE_KEY_SCHEMA_NAME_SUFFIX)) {
            LOGGER.warn("Expected Key Schema for transformation, passing it unchanged. Message key: \"{}\"", ((ConnectRecord)record).key());
            return false;
        }
        return true;
    }
}

