/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.listening;

import io.debezium.data.VariableScaleDecimal;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.extension.io.cdc.source.listening.ChangeDataCapture;
import io.siddhi.extension.io.cdc.source.metrics.ListeningMetrics;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.log4j.Logger;

public class RdbmsChangeDataCapture
extends ChangeDataCapture {
    private static final Logger log = Logger.getLogger(RdbmsChangeDataCapture.class);

    public RdbmsChangeDataCapture(String operation, SourceEventListener sourceEventListener, ListeningMetrics metrics) {
        super(operation, sourceEventListener, metrics);
    }

    @Override
    Map<String, Object> createMap(ConnectRecord connectRecord, String operation) {
        String op;
        HashMap<String, Object> detailsMap = new HashMap<String, Object>();
        Struct record = (Struct)connectRecord.value();
        try {
            op = (String)record.get("op");
        }
        catch (NullPointerException | DataException ex) {
            return detailsMap;
        }
        if (operation.equalsIgnoreCase("insert") && op.equals("c") || operation.equalsIgnoreCase("delete") && op.equals("d") || operation.equalsIgnoreCase("update") && op.equals("u")) {
            switch (op) {
                case "c": {
                    Struct rawDetails = (Struct)record.get("after");
                    List<Field> fields = rawDetails.schema().fields();
                    for (Field key : fields) {
                        String fieldName = key.name();
                        detailsMap.put(fieldName, this.getValue(rawDetails.get(fieldName)));
                    }
                    break;
                }
                case "d": {
                    Struct rawDetails = (Struct)record.get("before");
                    List<Field> fields = rawDetails.schema().fields();
                    for (Field key : fields) {
                        String fieldName = key.name();
                        detailsMap.put("before_" + fieldName, this.getValue(rawDetails.get(fieldName)));
                    }
                    break;
                }
                case "u": {
                    String fieldName;
                    Struct rawDetails = (Struct)record.get("before");
                    List<Field> fields = rawDetails.schema().fields();
                    for (Field key : fields) {
                        fieldName = key.name();
                        detailsMap.put("before_" + fieldName, this.getValue(rawDetails.get(fieldName)));
                    }
                    rawDetails = (Struct)record.get("after");
                    fields = rawDetails.schema().fields();
                    for (Field key : fields) {
                        fieldName = key.name();
                        detailsMap.put(fieldName, this.getValue(rawDetails.get(fieldName)));
                    }
                    break;
                }
                default: {
                    log.info((Object)("Provided value for \"op\" : " + op + " is not supported."));
                }
            }
        }
        return detailsMap;
    }

    private Object getValue(Object v) {
        if (v instanceof Struct) {
            Optional<BigDecimal> value = VariableScaleDecimal.toLogical((Struct)v).getDecimalValue();
            BigDecimal bigDecimal = value.orElse(null);
            if (bigDecimal == null) {
                return null;
            }
            return bigDecimal.longValue();
        }
        if (v instanceof Short) {
            return ((Short)v).intValue();
        }
        if (v instanceof Byte) {
            return ((Byte)v).intValue();
        }
        return v;
    }
}

