/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.metrics;

import io.siddhi.extension.io.cdc.source.metrics.CDCStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

public abstract class Metrics {
    static final Map<CDCDatabase, Long> CDC_LAST_RECEIVED_TIME_MAP = new HashMap<CDCDatabase, Long>();
    static final Map<CDCDatabase, CDCStatus> CDC_STATUS_MAP = new HashMap<CDCDatabase, CDCStatus>();
    static final Map<String, Boolean> CDC_STATUS_SERVICE_STARTED_MAP = new ConcurrentHashMap<String, Boolean>();
    protected final String siddhiAppName;
    protected final String tableName;
    protected final CDCDatabase cdcDatabase;
    protected String host;
    protected String databaseName;
    protected String dbType;

    public Metrics(String siddhiAppName, String url, String tableName) {
        this.siddhiAppName = siddhiAppName;
        this.tableName = tableName;
        this.cdcDatabase = new CDCDatabase(siddhiAppName, url + ":" + tableName);
        MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Cdc", siddhiAppName), Level.INFO, new Level[0]).inc();
    }

    public abstract void updateTableStatus(ExecutorService var1, String var2);

    public abstract Counter getEventCountMetric();

    protected abstract void lastReceivedTimeMetric();

    protected abstract void setCDCDBStatusMetric();

    public abstract void setCDCStatus(CDCStatus var1);

    public abstract void setLastReceivedTime(long var1);

    protected abstract void idleTimeMetric();

    protected String getDatabaseURL() {
        return this.dbType + ":" + this.host + "/" + this.databaseName + "/" + this.tableName;
    }

    public Counter getTotalReadsMetrics() {
        return MetricsDataHolder.getInstance().getMetricService().counter(String.format("io.siddhi.SiddhiApps.%s.Siddhi.Total.Reads.%s", this.siddhiAppName, "cdc"), Level.INFO, new Level[0]);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    protected static class CDCDatabase {
        protected String cdcURL;
        protected String siddhiAppName;

        public CDCDatabase(String siddhiAppName, String cdcURL) {
            this.cdcURL = cdcURL;
            this.siddhiAppName = siddhiAppName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CDCDatabase that = (CDCDatabase)o;
            return this.cdcURL.equals(that.cdcURL) && this.siddhiAppName.equals(that.siddhiAppName);
        }

        public int hashCode() {
            return Objects.hash(this.cdcURL, this.siddhiAppName);
        }
    }
}

