/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.polling.strategies;

import com.zaxxer.hikari.HikariDataSource;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.stream.input.source.SourceMapper;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.extension.io.cdc.source.config.Database;
import io.siddhi.extension.io.cdc.source.config.QueryConfiguration;
import io.siddhi.extension.io.cdc.source.metrics.CDCStatus;
import io.siddhi.extension.io.cdc.source.metrics.MetricsUtils;
import io.siddhi.extension.io.cdc.source.metrics.PollingMetrics;
import io.siddhi.extension.io.cdc.source.polling.CDCPollingModeException;
import io.siddhi.extension.io.cdc.util.CDCPollingUtil;
import io.siddhi.extension.io.cdc.util.MyYamlConstructor;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public abstract class PollingStrategy {
    private static final Logger log = Logger.getLogger(PollingStrategy.class);
    private static final String PLACE_HOLDER_TABLE_NAME = "{{TABLE_NAME}}";
    private static final String PLACE_HOLDER_COLUMN_LIST = "{{COLUMN_LIST}}";
    private static final String PLACE_HOLDER_CONDITION = "{{CONDITION}}";
    private static final String SELECT_QUERY_CONFIG_FILE = "query-config.yaml";
    private static final String RECORD_SELECT_QUERY = "recordSelectQuery";
    private HikariDataSource dataSource;
    private String selectQueryStructure = "";
    private ConfigReader configReader;
    private SourceEventListener sourceEventListener;
    private String appName;
    private String streamName;
    protected boolean paused = false;
    protected ReentrantLock pauseLock = new ReentrantLock();
    protected Condition pauseLockCondition = this.pauseLock.newCondition();
    protected String tableName;
    protected PollingMetrics metrics;

    public PollingStrategy(HikariDataSource dataSource, ConfigReader configReader, SourceEventListener sourceEventListener, String tableName, String appName, PollingMetrics metrics) {
        this.dataSource = dataSource;
        this.configReader = configReader;
        this.sourceEventListener = sourceEventListener;
        this.tableName = tableName;
        this.appName = appName;
        this.streamName = sourceEventListener.getStreamDefinition().getId();
        this.metrics = metrics;
    }

    public abstract void poll();

    public abstract String getLastReadPollingColumnValue();

    public abstract void setLastReadPollingColumnValue(String var1);

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
        try {
            this.pauseLock.lock();
            this.pauseLockCondition.signal();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    protected Connection getConnection() {
        Connection conn;
        try {
            conn = this.dataSource.getConnection();
            if (this.metrics != null) {
                this.metrics.setHost(MetricsUtils.getShortenedJDBCURL(conn.getMetaData().getURL()));
                this.metrics.setDbType(conn.getMetaData().getDatabaseProductName());
                this.metrics.setDatabaseName(conn.getCatalog());
                this.metrics.getTotalReadsMetrics();
                this.metrics.getEventCountMetric();
                this.metrics.getValidEventCountMetric();
                this.metrics.getTotalErrorCountMetric();
            }
            log.debug((Object)"A connection is initialized.");
        }
        catch (SQLException e) {
            if (this.metrics != null) {
                this.metrics.setCDCStatus(CDCStatus.ERROR);
            }
            throw new CDCPollingModeException(this.buildError("Error initializing datasource connection.", new Object[0]), e);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getSelectQuery(String columnList, String condition) {
        String databaseName;
        if (!this.selectQueryStructure.isEmpty()) return this.selectQueryStructure.replace(PLACE_HOLDER_TABLE_NAME, this.tableName).replace(PLACE_HOLDER_COLUMN_LIST, columnList).replace(PLACE_HOLDER_CONDITION, condition);
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            databaseName = dmd.getDatabaseProductName();
        }
        catch (SQLException e) {
            if (this.metrics == null) throw new CDCPollingModeException(this.buildError("Error in looking up database type.", new Object[0]), e);
            this.metrics.setCDCStatus(CDCStatus.ERROR);
            throw new CDCPollingModeException(this.buildError("Error in looking up database type.", new Object[0]), e);
        }
        finally {
            CDCPollingUtil.cleanupConnection(null, null, conn);
        }
        this.selectQueryStructure = this.configReader.readConfig(databaseName + "." + RECORD_SELECT_QUERY, "");
        if (this.selectQueryStructure.isEmpty()) {
            QueryConfiguration queryConfiguration;
            block19: {
                InputStream inputStream = null;
                try {
                    MyYamlConstructor constructor = new MyYamlConstructor(QueryConfiguration.class);
                    TypeDescription queryTypeDescription = new TypeDescription(QueryConfiguration.class);
                    queryTypeDescription.putListPropertyType("databases", Database.class);
                    constructor.addTypeDescription(queryTypeDescription);
                    Yaml yaml = new Yaml((BaseConstructor)constructor);
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    inputStream = classLoader.getResourceAsStream(SELECT_QUERY_CONFIG_FILE);
                    if (inputStream == null) {
                        throw new CDCPollingModeException(this.buildError("%s is not found in the classpath", SELECT_QUERY_CONFIG_FILE));
                    }
                    queryConfiguration = (QueryConfiguration)yaml.load(inputStream);
                    if (inputStream == null) break block19;
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (this.metrics != null) {
                            this.metrics.setCDCStatus(CDCStatus.ERROR);
                        }
                        log.error((Object)this.buildError("Failed to close the input stream for %s.", SELECT_QUERY_CONFIG_FILE));
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (this.metrics != null) {
                        this.metrics.setCDCStatus(CDCStatus.ERROR);
                    }
                    log.error((Object)this.buildError("Failed to close the input stream for %s.", SELECT_QUERY_CONFIG_FILE));
                }
            }
            if (queryConfiguration != null) {
                for (Database database : queryConfiguration.getDatabases()) {
                    if (!database.getName().equalsIgnoreCase(databaseName)) continue;
                    this.selectQueryStructure = database.getSelectQuery();
                    break;
                }
            }
        }
        if (!this.selectQueryStructure.isEmpty()) return this.selectQueryStructure.replace(PLACE_HOLDER_TABLE_NAME, this.tableName).replace(PLACE_HOLDER_COLUMN_LIST, columnList).replace(PLACE_HOLDER_CONDITION, condition);
        if (this.metrics != null) {
            this.metrics.setCDCStatus(CDCStatus.ERROR);
        }
        throw new CDCPollingModeException(this.buildError("Unsupported database: %s. Configure system parameter: %s.%s.", databaseName, databaseName, RECORD_SELECT_QUERY));
    }

    protected void handleEvent(Map detailsMap) {
        long previousEventCount = ((SourceMapper)this.sourceEventListener).getEventCount();
        this.sourceEventListener.onEvent((Object)detailsMap, null);
        if (this.metrics != null) {
            this.metrics.getTotalReadsMetrics().inc();
            this.metrics.getEventCountMetric().inc();
            long eventCount = ((SourceMapper)this.sourceEventListener).getEventCount() - previousEventCount;
            this.metrics.getValidEventCountMetric().inc(eventCount);
            this.metrics.setCDCStatus(CDCStatus.CONSUMING);
            this.metrics.setLastReceivedTime(System.currentTimeMillis());
        }
    }

    protected String buildError(String message, Object ... args) {
        return String.format(message, args) + " {mode=" + "polling" + ", app=" + this.appName + ", stream=" + this.streamName + "}";
    }
}

