/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.transforms.util.RegexValidator;

public class SinkConnectorConfig
extends ConnectorConfig {
    public static final String TOPICS_CONFIG = "topics";
    private static final String TOPICS_DOC = "List of topics to consume, separated by commas";
    public static final String TOPICS_DEFAULT = "";
    private static final String TOPICS_DISPLAY = "Topics";
    public static final String TOPICS_REGEX_CONFIG = "topics.regex";
    private static final String TOPICS_REGEX_DOC = "Regular expression giving topics to consume. Under the hood, the regex is compiled to a <code>java.util.regex.Pattern</code>. Only one of topics or topics.regex should be specified.";
    public static final String TOPICS_REGEX_DEFAULT = "";
    private static final String TOPICS_REGEX_DISPLAY = "Topics regex";
    public static final String DLQ_PREFIX = "errors.deadletterqueue.";
    public static final String DLQ_TOPIC_NAME_CONFIG = "errors.deadletterqueue.topic.name";
    public static final String DLQ_TOPIC_NAME_DOC = "The name of the topic to be used as the dead letter queue (DLQ) for messages that result in an error when processed by this sink connector, or its transformations or converters. The topic name is blank by default, which means that no messages are to be recorded in the DLQ.";
    public static final String DLQ_TOPIC_DEFAULT = "";
    private static final String DLQ_TOPIC_DISPLAY = "Dead Letter Queue Topic Name";
    public static final String DLQ_TOPIC_REPLICATION_FACTOR_CONFIG = "errors.deadletterqueue.topic.replication.factor";
    private static final String DLQ_TOPIC_REPLICATION_FACTOR_CONFIG_DOC = "Replication factor used to create the dead letter queue topic when it doesn't already exist.";
    public static final short DLQ_TOPIC_REPLICATION_FACTOR_CONFIG_DEFAULT = 3;
    private static final String DLQ_TOPIC_REPLICATION_FACTOR_CONFIG_DISPLAY = "Dead Letter Queue Topic Replication Factor";
    public static final String DLQ_CONTEXT_HEADERS_ENABLE_CONFIG = "errors.deadletterqueue.context.headers.enable";
    public static final boolean DLQ_CONTEXT_HEADERS_ENABLE_DEFAULT = false;
    public static final String DLQ_CONTEXT_HEADERS_ENABLE_DOC = "If true, add headers containing error context to the messages written to the dead letter queue. To avoid clashing with headers from the original record, all error context header keys, all error context header keys will start with <code>__connect.errors.</code>";
    private static final String DLQ_CONTEXT_HEADERS_ENABLE_DISPLAY = "Enable Error Context Headers";
    static ConfigDef config = ConnectorConfig.configDef().define("topics", ConfigDef.Type.LIST, "", ConfigDef.Importance.HIGH, "List of topics to consume, separated by commas", "Common", 4, ConfigDef.Width.LONG, "Topics").define("topics.regex", ConfigDef.Type.STRING, (Object)"", new RegexValidator(), ConfigDef.Importance.HIGH, "Regular expression giving topics to consume. Under the hood, the regex is compiled to a <code>java.util.regex.Pattern</code>. Only one of topics or topics.regex should be specified.", "Common", 4, ConfigDef.Width.LONG, "Topics regex").define("errors.deadletterqueue.topic.name", ConfigDef.Type.STRING, "", ConfigDef.Importance.MEDIUM, "The name of the topic to be used as the dead letter queue (DLQ) for messages that result in an error when processed by this sink connector, or its transformations or converters. The topic name is blank by default, which means that no messages are to be recorded in the DLQ.", "Error Handling", 6, ConfigDef.Width.MEDIUM, "Dead Letter Queue Topic Name").define("errors.deadletterqueue.topic.replication.factor", ConfigDef.Type.SHORT, (short)3, ConfigDef.Importance.MEDIUM, "Replication factor used to create the dead letter queue topic when it doesn't already exist.", "Error Handling", 7, ConfigDef.Width.MEDIUM, "Dead Letter Queue Topic Replication Factor").define("errors.deadletterqueue.context.headers.enable", ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, "If true, add headers containing error context to the messages written to the dead letter queue. To avoid clashing with headers from the original record, all error context header keys, all error context header keys will start with <code>__connect.errors.</code>", "Error Handling", 8, ConfigDef.Width.MEDIUM, "Enable Error Context Headers");

    public static ConfigDef configDef() {
        return config;
    }

    public SinkConnectorConfig(Plugins plugins, Map<String, String> props) {
        super(plugins, config, props);
    }

    public static void validate(Map<String, String> props) {
        boolean hasTopicsConfig = SinkConnectorConfig.hasTopicsConfig(props);
        boolean hasTopicsRegexConfig = SinkConnectorConfig.hasTopicsRegexConfig(props);
        if (hasTopicsConfig && hasTopicsRegexConfig) {
            throw new ConfigException("topics and topics.regex are mutually exclusive options, but both are set.");
        }
        if (!hasTopicsConfig && !hasTopicsRegexConfig) {
            throw new ConfigException("Must configure one of topics or topics.regex");
        }
    }

    public static boolean hasTopicsConfig(Map<String, String> props) {
        String topicsStr = props.get(TOPICS_CONFIG);
        return topicsStr != null && !topicsStr.trim().isEmpty();
    }

    public static boolean hasTopicsRegexConfig(Map<String, String> props) {
        String topicsRegexStr = props.get(TOPICS_REGEX_CONFIG);
        return topicsRegexStr != null && !topicsRegexStr.trim().isEmpty();
    }

    public String dlqTopicName() {
        return this.getString(DLQ_TOPIC_NAME_CONFIG);
    }

    public short dlqTopicReplicationFactor() {
        return this.getShort(DLQ_TOPIC_REPLICATION_FACTOR_CONFIG);
    }

    public boolean isDlqContextHeadersEnabled() {
        return this.getBoolean(DLQ_CONTEXT_HEADERS_ENABLE_CONFIG);
    }

    public static void main(String[] args) {
        System.out.println(config.toHtmlTable());
    }
}

