/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.email.client.connector;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.email.contract.EmailClientConnector;
import org.wso2.transport.email.contract.message.EmailBaseMessage;
import org.wso2.transport.email.contract.message.EmailMultipartMessage;
import org.wso2.transport.email.contract.message.EmailTextMessage;
import org.wso2.transport.email.exception.EmailConnectorException;

public class EmailClientConnectorImpl
implements EmailClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(EmailClientConnector.class);
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> waitTillTimeOut;
    private Session session;
    private Transport transport;
    private Boolean isInitMethodCalled = false;
    private Integer waitTimeBeforeConnectionClose;

    @Override
    public void init(Map<String, String> properties) throws EmailConnectorException {
        Properties serverProperties = new Properties();
        try {
            properties.forEach((key, value) -> {
                if (key.startsWith("mail.smtp") || key.startsWith("mail.store")) {
                    serverProperties.put(key, value);
                }
            });
        }
        catch (Exception e) {
            throw new EmailConnectorException("Error is encountered while casting value of property map into String." + e.getMessage(), e);
        }
        String username = properties.get("username");
        String password = properties.get("password");
        if (null == username || username.isEmpty()) {
            throw new EmailConnectorException("Username of the email account is a mandatory parameter.It is not given in the email property map.");
        }
        if (null == password || password.isEmpty()) {
            throw new EmailConnectorException("Password of the email account is a mandatory parameter.It is not given in the email property map.");
        }
        this.session = Session.getInstance(serverProperties, new EmailAuthenticator(username, password));
        try {
            this.transport = this.session.getTransport();
            this.transport.connect();
        }
        catch (NoSuchProviderException e) {
            throw new EmailConnectorException("Error is encountered while creating transport using the session." + e.getMessage(), e);
        }
        catch (MessagingException e) {
            throw new EmailConnectorException("Error is encountered while creating  the connection using the session." + e.getMessage(), e);
        }
        if (null != properties.get("waitTime")) {
            this.waitTimeBeforeConnectionClose = Integer.parseInt(properties.get("waitTime"));
        }
        this.isInitMethodCalled = true;
    }

    @Override
    public synchronized void send(EmailBaseMessage emailMessage) throws EmailConnectorException {
        if (!this.isInitMethodCalled.booleanValue()) {
            throw new EmailConnectorException("Should call 'init' method first, before calling the 'send' method");
        }
        if (null != this.waitTimeBeforeConnectionClose && this.waitTillTimeOut != null && !this.waitTillTimeOut.isDone()) {
            this.waitTillTimeOut.cancel(true);
        }
        Message message = this.createMessage(this.session, emailMessage);
        try {
            message.saveChanges();
        }
        catch (MessagingException e) {
            throw new EmailConnectorException("Error is encountered while saving the messages" + e.getMessage(), e);
        }
        if (this.transport.isConnected()) {
            try {
                this.transport.sendMessage(message, message.getAllRecipients());
            }
            catch (Exception e) {
                throw new EmailConnectorException("Error is encountered while sending the message. " + e.getMessage(), e);
            }
        }
        try {
            this.transport.connect();
        }
        catch (MessagingException e) {
            throw new EmailConnectorException("Error is encountered while connecting " + e.getMessage(), e);
        }
        try {
            this.transport.sendMessage(message, message.getAllRecipients());
        }
        catch (MessagingException e) {
            throw new EmailConnectorException("Error is encountered while sending the message." + e.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Message is send successfully" + message.toString());
        }
        if (null != this.waitTimeBeforeConnectionClose) {
            this.waitTillTimeOut = this.scheduler.schedule(() -> {
                if (this.transport.isConnected()) {
                    try {
                        this.transport.close();
                    }
                    catch (Exception e) {
                        logger.warn("Error is encountered while closing the connection after waiting waitTime minutes. " + e.getMessage(), (Throwable)e);
                    }
                }
            }, (long)this.waitTimeBeforeConnectionClose.intValue(), TimeUnit.MINUTES);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Message createMessage(Session session, EmailBaseMessage emailMessage) throws EmailConnectorException {
        String contentType;
        MimeMessage message = new MimeMessage(session);
        if (emailMessage.getHeader("Content-Type") != null) {
            if (emailMessage.getHeader("Content-Type").equalsIgnoreCase("text/plain")) {
                contentType = "text/plain";
            } else {
                if (!emailMessage.getHeader("Content-Type").equalsIgnoreCase("text/html")) throw new EmailConnectorException("Email content type should be either 'text/plain' or 'text/html'. But found '" + emailMessage.getHeader("contentType") + "'");
                contentType = "text/html";
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Email content type is not given. Default value: is taken as a content type");
            }
            contentType = "text/plain";
        }
        try {
            if (emailMessage instanceof EmailTextMessage) {
                String textData = ((EmailTextMessage)emailMessage).getText();
                if (textData == null) {
                    throw new EmailConnectorException("Email message content couldn't be null");
                }
                message.setContent(textData, contentType);
            } else {
                if (!(emailMessage instanceof EmailMultipartMessage)) throw new EmailConnectorException("Email client connector only support EmailTextMessage or EmailMultipartMessage");
                EmailMultipartMessage emailMsg = (EmailMultipartMessage)emailMessage;
                String text = emailMsg.getText();
                List<String> attachments = emailMsg.getAttachments();
                MimeMultipart multipart = new MimeMultipart();
                if (text != null) {
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setContent(text, contentType);
                    ((Multipart)multipart).addBodyPart(messageBodyPart);
                }
                if (attachments != null) {
                    for (String path : attachments) {
                        EmailClientConnectorImpl.attachFiles(message, multipart, path);
                    }
                }
                message.setContent(multipart);
            }
            if (emailMessage.getHeader("Subject") == null) {
                throw new EmailConnectorException("Subject of the email is not given");
            }
            ((Message)message).setSubject(emailMessage.getHeader("Subject"));
            if (emailMessage.getHeader("To") == null) {
                throw new EmailConnectorException("RecipientType 'to' of the email is not given. It is a mandatory parameter in email client connector.");
            }
            ((Message)message).setRecipients(Message.RecipientType.TO, InternetAddress.parse(emailMessage.getHeader("To")));
            if (emailMessage.getHeader("Bcc") != null) {
                ((Message)message).setRecipients(Message.RecipientType.BCC, InternetAddress.parse(emailMessage.getHeader("Bcc")));
            }
            if (emailMessage.getHeader("Cc") != null) {
                ((Message)message).setRecipients(Message.RecipientType.CC, InternetAddress.parse(emailMessage.getHeader("Cc")));
            }
            if (emailMessage.getHeader("From") != null) {
                ((Message)message).setFrom(new InternetAddress(emailMessage.getHeader("From")));
            }
            if (emailMessage.getHeader("Reply-To") != null) {
                Address[] addresses = new InternetAddress[]{new InternetAddress(emailMessage.getHeader("Reply-To"))};
                ((Message)message).setReplyTo(addresses);
            }
            if (emailMessage.getHeader("In-Reply-To") != null) {
                message.setHeader("In-Reply-To", emailMessage.getHeader("In-Reply-To"));
            }
            if (emailMessage.getHeader("Message-ID") != null) {
                message.setHeader("Message-ID", emailMessage.getHeader("Message-ID"));
            }
            if (emailMessage.getHeader("References") == null) return message;
            message.setHeader("References", emailMessage.getHeader("References"));
            return message;
        }
        catch (MessagingException e) {
            throw new EmailConnectorException("Error occurred while creating the email using given carbon message. " + e.getMessage(), e);
        }
    }

    private static void attachFiles(Message message, Multipart multipart, String sourcePath) throws MessagingException {
        File source = new File(sourcePath);
        if (source.isDirectory()) {
            File[] files = source.listFiles();
            if (files != null) {
                for (File file : files) {
                    EmailClientConnectorImpl.attachFile(multipart, file);
                }
            }
        } else if (source.isFile()) {
            EmailClientConnectorImpl.attachFile(multipart, source);
        }
        message.setContent(multipart);
    }

    private static void attachFile(Multipart multipart, File file) throws MessagingException {
        MimeBodyPart attachPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(file.getAbsolutePath());
        attachPart.setDataHandler(new DataHandler((DataSource)source));
        attachPart.setFileName(file.getName());
        multipart.addBodyPart(attachPart);
    }

    private static class EmailAuthenticator
    extends Authenticator {
        private final String username;
        private final String password;

        public EmailAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

