/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.email.server.connector.contractimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.search.AndTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.connector.framework.server.polling.PollingServerConnector;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.exceptions.ServerConnectorException;
import org.wso2.transport.email.contract.EmailMessageListener;
import org.wso2.transport.email.contract.EmailServerConnector;
import org.wso2.transport.email.exception.EmailConnectorException;
import org.wso2.transport.email.server.connector.EmailConsumer;

public class EmailServerConnectorImpl
extends PollingServerConnector
implements EmailServerConnector {
    private static final Logger log = LoggerFactory.getLogger(EmailServerConnector.class);
    private SearchTerm emailSearchTerm;
    private String stringEmailSearchTerm = null;
    private Long startUIDNumber = 1L;
    private Long emailConnectorDefaultPollingInterval = 360000L;
    private EmailConsumer consumer = null;

    public EmailServerConnectorImpl(String id, Map<String, String> properties) {
        super(id, properties);
        this.stringEmailSearchTerm = properties.get("searchTerm");
        this.interval = this.emailConnectorDefaultPollingInterval;
    }

    public void setMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
    }

    @Override
    public void init() throws EmailConnectorException {
        if (this.stringEmailSearchTerm != null) {
            this.emailSearchTerm = this.stringToSearchTermConverter(this.stringEmailSearchTerm);
        }
        this.consumer = new EmailConsumer(this.id, this.getProperties(), this.emailSearchTerm);
        this.consumer.setStartUIDNumber(this.startUIDNumber);
        this.consumer.connectToEmailStore();
        this.consumer.setAction();
    }

    @Override
    public void destroy() throws EmailConnectorException {
        try {
            if (this.consumer != null) {
                this.consumer.closeAll();
            }
        }
        finally {
            this.consumer = null;
            this.startUIDNumber = 1L;
        }
        this.stop();
    }

    @Override
    public void start(EmailMessageListener emailMessageListener) throws EmailConnectorException {
        this.consumer.setEmailMessageListener(emailMessageListener);
        try {
            super.start();
        }
        catch (Exception e) {
            throw new EmailConnectorException("Error is encountered while initializing the polling cycle for email server connector for service:" + this.id, e);
        }
    }

    @Override
    public void stop() throws EmailConnectorException {
        try {
            super.stop();
        }
        catch (ServerConnectorException e) {
            throw new EmailConnectorException("Error is encountered while trying to stop the Email server Connectorfor service: " + this.id, e);
        }
        if (this.consumer != null) {
            this.startUIDNumber = this.consumer.getStartUIDNumber();
        }
    }

    @Override
    protected void poll() {
        try {
            this.consumer.consume();
        }
        catch (EmailConnectorException e) {
            log.error(" Error is encountered while executing the polling cycle of email server connector for service: " + this.id, (Throwable)((Object)e));
        }
    }

    private SearchTerm stringToSearchTermConverter(String stringSearchTerm) throws EmailConnectorException {
        AndTerm searchTerm = null;
        HashMap<String, String> searchConditionMap = new HashMap<String, String>();
        ArrayList<SearchTerm> searchTermsList = new ArrayList<SearchTerm>();
        String pattern = "^(([ ]*[a-zA-Z]*[ ]*:[^:,]*,[ ]*)*[ ]*[a-zA-Z]*[ ]*:[^:,]*$)";
        if (!stringSearchTerm.matches(pattern)) {
            throw new EmailConnectorException("String search term '" + stringSearchTerm + "' is not in correct format in Email Server Connector" + "for service: " + this.id);
        }
        String[] condition = stringSearchTerm.split(",");
        for (int i = 0; i < condition.length; ++i) {
            String[] nameValuePair = condition[i].split(":");
            if (nameValuePair.length != 2) {
                throw new EmailConnectorException("The given key value pair '" + nameValuePair[i] + "' in string search term is not in the correct format in Email server Connector for service:" + " " + this.id);
            }
            searchConditionMap.put(nameValuePair[0].trim().toUpperCase(Locale.ENGLISH), nameValuePair[1].trim());
        }
        if (searchConditionMap.size() > 0) {
            block17: for (Map.Entry entry : searchConditionMap.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "SUBJECT": {
                        try {
                            SubjectTerm subjectTerm = new SubjectTerm((String)entry.getValue());
                            searchTermsList.add(subjectTerm);
                        }
                        catch (Exception e) {
                            log.error("Error is encountered while searching messages using subject. in the email server connector for service:" + this.id, (Throwable)e);
                        }
                        continue block17;
                    }
                    case "FROM": {
                        final String fromAddress = ((String)entry.getValue()).toLowerCase(Locale.ENGLISH);
                        SearchTerm fromAddressTerm = new SearchTerm(){

                            @Override
                            public boolean match(Message message) {
                                try {
                                    Address[] from;
                                    for (Address ad : from = message.getFrom()) {
                                        String fromAd = ((InternetAddress)ad).getAddress();
                                        if (!(fromAddress.contains("@") ? fromAd.startsWith(fromAddress) : fromAd.contains(fromAddress))) continue;
                                        return true;
                                    }
                                }
                                catch (MessagingException e) {
                                    log.error("Error is encountered while searching the message using From address in the email server connector with id:" + EmailServerConnectorImpl.this.id, (Throwable)e);
                                }
                                return false;
                            }
                        };
                        searchTermsList.add(fromAddressTerm);
                        continue block17;
                    }
                    case "TO": {
                        final String toAddress = ((String)entry.getValue()).toLowerCase(Locale.ENGLISH);
                        SearchTerm toAddressTerm = new SearchTerm(){

                            @Override
                            public boolean match(Message message) {
                                try {
                                    if (message.getRecipients(Message.RecipientType.TO) != null) {
                                        Address[] to;
                                        for (Address ad : to = message.getRecipients(Message.RecipientType.TO)) {
                                            String toAd = ((InternetAddress)ad).getAddress();
                                            if (!(toAddress.contains("@") ? toAd.startsWith(toAddress) : toAd.contains(toAddress))) continue;
                                            return true;
                                        }
                                    }
                                }
                                catch (MessagingException e) {
                                    log.error("Error is encountered while searching the message using To address in the email server connector for service:" + EmailServerConnectorImpl.this.id, (Throwable)e);
                                }
                                return false;
                            }
                        };
                        searchTermsList.add(toAddressTerm);
                        continue block17;
                    }
                    case "BCC": {
                        final String bccAddress = ((String)entry.getValue()).toLowerCase(Locale.ENGLISH);
                        SearchTerm bccAddressTerm = new SearchTerm(){

                            @Override
                            public boolean match(Message message) {
                                try {
                                    if (message.getRecipients(Message.RecipientType.BCC) != null) {
                                        Address[] bcc;
                                        for (Address ad : bcc = message.getRecipients(Message.RecipientType.BCC)) {
                                            String bccAd = ((InternetAddress)ad).getAddress();
                                            if (!(bccAddress.contains("@") ? bccAd.startsWith(bccAddress) : bccAd.contains(bccAddress))) continue;
                                            return true;
                                        }
                                    }
                                }
                                catch (MessagingException e) {
                                    log.error("Error is encountered while searching the message using bcc address in the email server connector for service:" + EmailServerConnectorImpl.this.id, (Throwable)e);
                                }
                                return false;
                            }
                        };
                        searchTermsList.add(bccAddressTerm);
                        continue block17;
                    }
                    case "CC": {
                        final String ccAddress = ((String)entry.getValue()).toLowerCase(Locale.ENGLISH);
                        SearchTerm ccAddressTerm = new SearchTerm(){

                            @Override
                            public boolean match(Message message) {
                                try {
                                    if (message.getRecipients(Message.RecipientType.CC) != null) {
                                        Address[] cc;
                                        for (Address ad : cc = message.getRecipients(Message.RecipientType.CC)) {
                                            String ccAd = ((InternetAddress)ad).getAddress();
                                            if (!(ccAddress.contains("@") ? ccAd.startsWith(ccAddress) : ccAd.contains(ccAddress))) continue;
                                            return true;
                                        }
                                    }
                                }
                                catch (MessagingException e) {
                                    log.error("Error is encountered while searching the message using Cc address in the email server connector for service: " + EmailServerConnectorImpl.this.id, (Throwable)e);
                                }
                                return false;
                            }
                        };
                        searchTermsList.add(ccAddressTerm);
                        continue block17;
                    }
                }
                throw new EmailConnectorException("The given key '" + (String)entry.getKey() + "' in the String email search term " + "is not supported by" + " the email transport");
            }
        }
        searchTerm = new AndTerm(searchTermsList.toArray(new SearchTerm[searchTermsList.size()]));
        return searchTerm;
    }
}

