/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.email.utils;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.pop3.POP3Folder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.UIDFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.email.contract.message.EmailBaseMessage;
import org.wso2.transport.email.contract.message.EmailTextMessage;
import org.wso2.transport.email.exception.EmailConnectorException;
import org.wso2.transport.email.utils.Constants;

public class EmailUtils {
    private static final Logger log = LoggerFactory.getLogger(EmailUtils.class);

    public static Constants.ActionAfterProcessed getActionAfterProcessed(String action, Boolean isImapFolder) throws EmailConnectorException {
        if (action != null) {
            String actionInUpperCase = action.toUpperCase(Locale.ENGLISH);
            if (isImapFolder.booleanValue()) {
                switch (actionInUpperCase) {
                    case "SEEN": {
                        return Constants.ActionAfterProcessed.SEEN;
                    }
                    case "FLAGGED": {
                        return Constants.ActionAfterProcessed.FLAGGED;
                    }
                    case "ANSWERED": {
                        return Constants.ActionAfterProcessed.ANSWERED;
                    }
                    case "DELETE": {
                        return Constants.ActionAfterProcessed.DELETE;
                    }
                    case "MOVE": {
                        return Constants.ActionAfterProcessed.MOVE;
                    }
                }
                throw new EmailConnectorException(" action '" + action + "' is not supported by email server connector.");
            }
            switch (actionInUpperCase) {
                case "DELETE": {
                    return Constants.ActionAfterProcessed.DELETE;
                }
            }
            throw new EmailConnectorException("Action '" + action + "' is not supported by POP3Folder.");
        }
        if (isImapFolder.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.warn("Action after processed mail parameter is not defined. Get default action : SEEN.");
            }
            return Constants.ActionAfterProcessed.SEEN;
        }
        if (log.isDebugEnabled()) {
            log.warn("Action after processed mail parameter is not defined Get default action : DELETE.");
        }
        return Constants.ActionAfterProcessed.DELETE;
    }

    public static EmailBaseMessage createEmailMessage(Message message, Folder folder, String emailMessageContent, String serviceId) throws EmailConnectorException {
        try {
            EmailTextMessage emailMessage = new EmailTextMessage(emailMessageContent);
            Enumeration headers = message.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header h = (Header)headers.nextElement();
                emailMessage.setHeader(h.getName(), h.getValue());
            }
            emailMessage.setProperty("serviceName", serviceId);
            emailMessage.setProperty("messageNumber", message.getMessageNumber());
            if (folder instanceof IMAPFolder) {
                ArrayList<String> flagList = new ArrayList<String>();
                if (message.isSet(Flags.Flag.SEEN)) {
                    flagList.add("SEEN");
                }
                if (message.isSet(Flags.Flag.ANSWERED)) {
                    flagList.add("ANSWERED");
                }
                if (message.isSet(Flags.Flag.FLAGGED)) {
                    flagList.add("FLAGGED");
                }
                if (message.isSet(Flags.Flag.DELETED)) {
                    flagList.add("DELETED");
                }
                String flags = String.join((CharSequence)",", flagList);
                emailMessage.setProperty("flags", flags);
                emailMessage.setProperty("messageUid", ((UIDFolder)((Object)folder)).getUID(message));
            } else if (folder instanceof POP3Folder) {
                emailMessage.setProperty("messageUid", ((POP3Folder)folder).getUID(message));
            }
            return emailMessage;
        }
        catch (MessageRemovedException e) {
            throw new EmailConnectorException("Error is encountered while creating the carbon message since it has been deleted by another thread." + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new EmailConnectorException("Error is encountered while creating a carbon message." + e.getMessage(), e);
        }
    }
}

