/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.email.server.connector;

import com.sun.mail.imap.IMAPFolder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.email.contract.EmailMessageListener;
import org.wso2.transport.email.contract.message.EmailBaseMessage;
import org.wso2.transport.email.exception.EmailConnectorException;
import org.wso2.transport.email.server.connector.ActionForProcessedMail;
import org.wso2.transport.email.utils.Constants;
import org.wso2.transport.email.utils.EmailUtils;

public class EmailConsumer {
    private static final Logger log = LoggerFactory.getLogger(EmailConsumer.class);
    private SearchTerm emailSearchTerm;
    private Map<String, String> emailProperties;
    private EmailMessageListener emailMessageListener;
    private String serviceId;
    private Session session;
    private Folder folder;
    private long startUIDNumberOfNextPollCycle = 1L;
    private long uidOfLastMailFetched = 1L;
    private Store store;
    private String host;
    private String username;
    private String password;
    private String storeType;
    private int maxRetryCount;
    private Long retryInterval;
    private String folderName;
    private String contentType;
    private Constants.ActionAfterProcessed action;
    private Folder moveToFolder = null;
    private boolean isFirstTimeConnect = true;
    private boolean autoAcknowledge = true;
    private boolean isImapFolder = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EmailConsumer(String id, Map<String, String> properties, SearchTerm emailSearchTerm) throws EmailConnectorException {
        this.serviceId = id;
        this.emailProperties = properties;
        this.emailSearchTerm = emailSearchTerm;
        if (this.emailProperties.get("username") == null) {
            throw new EmailConnectorException("Username (email address) of the email account is a mandatory parameter. It is not given in the email property map in the email server connector with service id: " + this.serviceId + ".");
        }
        this.username = this.emailProperties.get("username");
        if (this.emailProperties.get("password") == null) {
            throw new EmailConnectorException("Password of the email account is a mandatory parameter. It is not given in the email property map in the email server connector with service id: " + this.serviceId + ".");
        }
        this.password = this.emailProperties.get("password");
        if (this.emailProperties.get("hostName") == null) {
            throw new EmailConnectorException("HostName of the email account is a mandatory parameter. It is not given in the email property map in the email server connector with service id: " + this.serviceId + ".");
        }
        this.host = this.emailProperties.get("hostName");
        if (this.emailProperties.get("storeType") == null) {
            throw new EmailConnectorException("Store type of the email account is a mandatory parameter. It is not given in the email property map in the email server connector with service id: " + this.serviceId + ".");
        }
        this.storeType = this.emailProperties.get("storeType");
        if (this.emailProperties.get("retryCount") != null) {
            try {
                this.maxRetryCount = Integer.parseInt(this.emailProperties.get("retryCount"));
            }
            catch (NumberFormatException e) {
                throw new EmailConnectorException("Could not parse parameter '" + this.emailProperties.get("retryCount") + "' to numeric type 'Integer'" + " in the email server connector for service id :" + this.serviceId + ".");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Max retry count is not given in the email property map. Get default max retry count '1' by the email server connector for service id:" + this.serviceId + ".");
            }
            this.maxRetryCount = 1;
        }
        if (this.emailProperties.get("retryInterval") != null) {
            try {
                this.retryInterval = Long.parseLong(this.emailProperties.get("retryInterval"));
            }
            catch (NumberFormatException e) {
                throw new EmailConnectorException("Could not parse parameter '" + this.emailProperties.get("retryInterval") + " to numeric type 'Long'" + " in the email server connector for service id: " + this.serviceId + ".");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Retry interval is not given in the email property map. Get default retry interval '" + Constants.DEFAULT_RETRY_INTERVAL + "' by " + "the email server connector for service id:" + this.serviceId + ".");
            }
            this.retryInterval = Constants.DEFAULT_RETRY_INTERVAL;
        }
        if (this.emailProperties.get("contentType") != null) {
            if (this.emailProperties.get("contentType").equalsIgnoreCase("text/html")) {
                this.contentType = "text/html";
            } else {
                if (!this.emailProperties.get("contentType").equalsIgnoreCase("text/plain")) throw new EmailConnectorException("Content type '" + this.emailProperties.get("contentType") + "' is not supported by" + " the email server connector for service id: " + this.serviceId + ".");
                this.contentType = "text/plain";
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Content type is not given in the email property map. Get default content type 'text/plain' by the email server connector for service id:" + this.serviceId + ".");
            }
            this.contentType = "text/plain";
        }
        if (this.emailProperties.get("folderName") != null) {
            this.folderName = this.emailProperties.get("folderName");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Folder to fetch mails is not given in the email property map. Get default folder 'INBOX' by the email server connector for service id: " + this.serviceId + ".");
            }
            this.folderName = "INBOX";
        }
        if (this.emailProperties.get("autoAcknowledge") != null) {
            this.autoAcknowledge = Boolean.parseBoolean(this.emailProperties.get("autoAcknowledge"));
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Auto Acknowledgement property is not given in the email property map. Get default value 'true' by the email server connector for service id: " + this.serviceId + ".");
            }
            this.autoAcknowledge = Constants.DEFAULT_AUTO_ACKNOWLEDGE_VALUE;
        }
        Properties serverProperties = new Properties();
        this.emailProperties.forEach((k, v) -> {
            if (k.startsWith("mail." + this.storeType)) {
                serverProperties.put(k, v);
            }
        });
        this.session = Session.getInstance(serverProperties);
        try {
            this.store = this.session.getStore(this.storeType);
            return;
        }
        catch (NoSuchProviderException e) {
            throw new EmailConnectorException("Couldn't initialize the store '" + this.storeType + "' in the email server connector for service id: " + this.serviceId + "." + e.getMessage(), e);
        }
    }

    public void setEmailMessageListener(EmailMessageListener emailMessageListener) {
        this.emailMessageListener = emailMessageListener;
    }

    public void consume() throws EmailConnectorException {
        this.openFolder(this.folder);
        List<Message> messageList = this.fetchEmails();
        if (messageList != null) {
            for (Message message : messageList) {
                try {
                    String content = this.getEmailContent(message);
                    if (!content.isEmpty()) {
                        EmailBaseMessage emailMessage = EmailUtils.createEmailMessage(message, this.folder, content, this.serviceId);
                        if (this.autoAcknowledge) {
                            this.emailMessageListener.onMessage(emailMessage);
                        } else {
                            this.emailMessageListener.onMessage(emailMessage);
                            emailMessage.waitTillAck();
                        }
                        if (this.isImapFolder) {
                            this.startUIDNumberOfNextPollCycle = Long.parseLong(emailMessage.getProperty("messageUid").toString()) + 1L;
                        }
                        ActionForProcessedMail.carryOutAction(message, this.folder, this.action, this.moveToFolder);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Skip the message #: " + message.getMessageNumber() + " by further processing" + " in Email Server Connector for service: " + this.serviceId + ".");
                }
                catch (RuntimeException e) {
                    log.error("Catch a run time exception while processing the message in Email Server Connector for service: " + this.serviceId + "." + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    log.warn("Skip the message #: " + message.getMessageNumber() + " by further processing in Email " + "Server Connector for service: " + this.serviceId + "." + e.getMessage(), (Throwable)e);
                }
            }
            if (this.isImapFolder && !this.autoAcknowledge) {
                this.startUIDNumberOfNextPollCycle = this.uidOfLastMailFetched + 1L;
            }
        }
        this.closeFolder(this.folder);
        if (this.moveToFolder != null) {
            this.closeFolder(this.moveToFolder);
        }
    }

    public void connectToEmailStore() throws EmailConnectorException {
        int retryCount = 0;
        while (!this.store.isConnected()) {
            block12: {
                try {
                    ++retryCount;
                    if (log.isDebugEnabled()) {
                        log.debug("Attempting to connect to '" + this.storeType + "' server for : " + this.emailProperties.get("username"));
                    }
                    this.store.connect(this.host, this.username, this.password);
                }
                catch (MessagingException e) {
                    log.error("Error connecting to mail server for address '" + this.username + "' in the email server connector with id : " + this.serviceId + ".", (Throwable)e);
                    if (this.maxRetryCount > retryCount) break block12;
                    throw new EmailConnectorException("Error connecting to mail server for the address '" + this.username + "' in the email server connector with id: " + this.serviceId + ".", e);
                }
            }
            if (this.store.isConnected()) {
                if (log.isDebugEnabled()) {
                    log.debug("Connected to the server: " + this.store);
                }
                if (this.isFirstTimeConnect) {
                    try {
                        this.folder = this.store.getFolder(this.folderName);
                        this.isFirstTimeConnect = false;
                        if (this.folder instanceof IMAPFolder) {
                            this.isImapFolder = true;
                        }
                    }
                    catch (MessagingException e) {
                        throw new EmailConnectorException("Error is encountered, while getting the folder '" + this.folderName + "' in email server connector with service id: " + this.serviceId + "." + e.getMessage());
                    }
                }
            }
            if (this.store.isConnected()) continue;
            try {
                log.warn("Connection to mail server for account : " + this.username + " using service '" + this.serviceId + "' is failed. Retrying in '" + this.retryInterval / 1000L + "' seconds");
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Thread is interrupted. It is ignored by the email server connector.", (Throwable)e);
            }
        }
    }

    public void setAction() throws EmailConnectorException {
        this.action = EmailUtils.getActionAfterProcessed(this.emailProperties.get("actionAfterProcessed"), this.isImapFolder);
        if (this.action.equals((Object)Constants.ActionAfterProcessed.MOVE)) {
            if (this.emailProperties.get("moveToFolder") != null) {
                try {
                    this.moveToFolder = this.store.getFolder(this.emailProperties.get("moveToFolder"));
                    if (!this.moveToFolder.exists()) {
                        this.moveToFolder.create(1);
                    }
                    this.openFolder(this.moveToFolder);
                }
                catch (MessagingException e) {
                    throw new EmailConnectorException("Couldn't process the folder '" + this.moveToFolder + "'which used to move the processed mail" + " in the email server connector with id: " + this.serviceId + "." + e.getMessage(), e);
                }
            } else {
                throw new EmailConnectorException("moveToFolder is a mandatory parameter, since the action for the processed mail is 'MOVE' in the email server connector with id: " + this.serviceId + ".");
            }
        }
    }

    protected void openFolder(Folder folder) throws EmailConnectorException {
        if (this.store.isConnected()) {
            try {
                if (!folder.isOpen()) {
                    folder.open(2);
                }
                this.closeFolder(folder);
                folder.open(2);
            }
            catch (MessagingException e) {
                throw new EmailConnectorException("Couldn't open the folder '" + this.folderName + " ' in READ_WRITE mode" + " in the email server connector with id: " + this.serviceId + "." + e.getMessage(), e);
            }
        } else {
            try {
                this.connectToEmailStore();
                folder.open(2);
            }
            catch (MessagingException e) {
                throw new EmailConnectorException("Couldn't open the folder '" + this.folderName + " ' in READ_WRITE mode" + " in the email server connector with id: " + this.serviceId + "." + e.getMessage(), e);
            }
        }
    }

    protected void closeFolder(Folder folder) throws EmailConnectorException {
        if (folder.isOpen()) {
            try {
                folder.close(true);
            }
            catch (MessagingException e) {
                log.warn("Couldn't close the folder '" + this.folderName + "' by the email server connector" + " with service id: " + this.serviceId + "." + e.getMessage(), (Throwable)e);
            }
        }
    }

    private List<Message> fetchEmails() throws EmailConnectorException {
        List<Message> messageList = null;
        if (log.isDebugEnabled()) {
            log.debug("Start to fetch the emails by email server connector with id: " + this.serviceId + ".");
        }
        try {
            if (this.isImapFolder) {
                Message[] messages = ((UIDFolder)((Object)this.folder)).getMessagesByUID(this.startUIDNumberOfNextPollCycle, -1L);
                if (messages.length > 0) {
                    long uid;
                    if (messages.length == 1 && this.startUIDNumberOfNextPollCycle > (uid = ((UIDFolder)((Object)this.folder)).getUID(messages[messages.length - 1]))) {
                        return messageList;
                    }
                    if (this.emailSearchTerm != null) {
                        Message[] filterMessages = this.folder.search(this.emailSearchTerm, messages);
                        if (filterMessages.length > 0) {
                            messageList = Arrays.asList(filterMessages);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Conditions(Search Term) is not specified. All the mails in the folder '" + this.folderName + "' will be fetched " + "by the email server connector " + "with id: " + this.serviceId + ".");
                        }
                        messageList = Arrays.asList(messages);
                    }
                    this.uidOfLastMailFetched = ((UIDFolder)((Object)this.folder)).getUID(messages[messages.length - 1]);
                    if (this.autoAcknowledge) {
                        this.startUIDNumberOfNextPollCycle = this.uidOfLastMailFetched + 1L;
                    }
                }
            } else if (this.emailSearchTerm != null) {
                Message[] messages = this.folder.search(this.emailSearchTerm);
                messageList = Arrays.asList(messages);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Conditions(Search Term) is not specified. All the mails in the folder '" + this.folderName + "' will be fetched" + "by the email server connector " + "with id: " + this.serviceId + ".");
                }
                Message[] messages = this.folder.getMessages();
                messageList = Arrays.asList(messages);
            }
        }
        catch (Exception e) {
            throw new EmailConnectorException("Error is encountered while fetching emails using search term from the folder '" + this.folderName + "'" + "by the email server connector with id: " + this.serviceId + "." + e.getMessage(), e);
        }
        if (log.isDebugEnabled() && messageList != null) {
            if (!this.isImapFolder) {
                log.debug("Number of email '" + messageList.size() + "' are fetched.");
            } else {
                log.debug("Number of email '" + messageList.size() + "' are fetched." + " Last UID of the mail is '" + this.uidOfLastMailFetched + "'");
            }
        }
        return messageList;
    }

    public Long getStartUIDNumber() {
        return this.startUIDNumberOfNextPollCycle;
    }

    public void closeAll() throws EmailConnectorException {
        try {
            if (this.store != null && this.store.isConnected()) {
                if (this.folder != null && this.folder.isOpen()) {
                    this.folder.close(true);
                }
                this.store.close();
            }
        }
        catch (Exception e) {
            throw new EmailConnectorException("Error is encountered while closing the connection for the email server connector with id: " + this.serviceId + "." + e.getMessage(), e);
        }
    }

    public void setStartUIDNumber(Long startUIDNumber) {
        this.startUIDNumberOfNextPollCycle = startUIDNumber;
    }

    private String getEmailContent(Message message) throws EmailConnectorException {
        String content = "";
        try {
            if (message instanceof MimeMessage) {
                if (message.isMimeType("text/plain")) {
                    if (this.contentType.equals("text/plain")) {
                        content = message.getContent().toString();
                    }
                } else if (message.isMimeType("text/html")) {
                    if (this.contentType.equals("text/html")) {
                        content = message.getContent().toString();
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Message with subject: " + message.getSubject() + ", is skipped from further" + " processing, since content type '" + message.getContentType() + "' of the email is not supported by the email server connector" + " with id: " + this.serviceId + ".");
                }
                return content;
            }
            throw new EmailConnectorException("Couldn't read the content of the email by the  since message is not a instance of MimeMessage");
        }
        catch (MessageRemovedException e) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping message # : " + message.getMessageNumber() + " as it has been DELETED by another thread after processing");
            }
            throw new EmailConnectorException("Couldn't read the content of the message #" + message.getMessageNumber() + "by the email server connector with service id '" + this.serviceId + "' since it has been DELETED by another thread." + e.getMessage(), e);
        }
        catch (IOException | MessagingException e) {
            throw new EmailConnectorException("Error is encountered while reading the content of a message by the email server connector with service id '" + this.serviceId + "'" + e.getMessage(), e);
        }
    }
}

