/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.email.sink.transport;

import io.siddhi.extension.io.email.sink.transport.EmailClientConnectionPoolFactory;
import java.util.Map;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.wso2.transport.email.contract.EmailConnectorFactory;
import org.wso2.transport.email.exception.EmailConnectorException;

public class EmailClientConnectionPoolManager {
    private static GenericKeyedObjectPool connectionPool;

    public static synchronized void initializeConnectionPool(EmailConnectorFactory emailConnectorFactory, Map<String, String> clientProperties) throws EmailConnectorException {
        EmailClientConnectionPoolFactory emailClientConnectionPoolFactory = new EmailClientConnectionPoolFactory(emailConnectorFactory, clientProperties);
        if (connectionPool == null) {
            int poolSize = Integer.parseInt(clientProperties.get("connection.pool.size"));
            connectionPool = new GenericKeyedObjectPool();
            connectionPool.setFactory((KeyedPoolableObjectFactory)emailClientConnectionPoolFactory);
            connectionPool.setMaxTotal(poolSize);
            connectionPool.setMaxActive(poolSize);
            connectionPool.setTestOnBorrow(true);
            connectionPool.setWhenExhaustedAction((byte)1);
        }
    }

    public static GenericKeyedObjectPool getConnectionPool() {
        return connectionPool;
    }

    public static void uninitializeConnectionPool() {
        connectionPool = null;
    }
}

