/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.framework.server.polling;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.connector.framework.server.polling.PollingServerConnector;

public class PollingJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(PollingJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        SchedulerContext schedulerContext = null;
        try {
            schedulerContext = jobExecutionContext.getScheduler().getContext();
        }
        catch (SchedulerException e1) {
            log.debug("Exception occurred while getting scheduler context", (Throwable)e1);
        }
        if (schedulerContext == null) {
            log.error("Scheduler context is null");
            return;
        }
        PollingServerConnector connector = (PollingServerConnector)((Object)schedulerContext.get((Object)"connector"));
        log.debug("Executing the polling task for server connector ID: " + connector.getId());
        try {
            connector.poll();
        }
        catch (Exception e) {
            log.error("Error executing the polling cycle for server connector ID: " + connector.getId(), (Throwable)e);
        }
        log.debug("Exit the polling task running loop for server connector ID: " + connector.getId());
    }
}

