/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.email.source;

import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.stream.input.source.SourceEventListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.transport.email.contract.EmailMessageListener;
import org.wso2.transport.email.contract.message.EmailBaseMessage;
import org.wso2.transport.email.contract.message.EmailTextMessage;

class EmailSourceMessageListener
implements EmailMessageListener {
    private static final Logger log = LogManager.getLogger(EmailSourceMessageListener.class);
    private SourceEventListener sourceEventListener;
    private String[] requiredProperties;
    private String contentType;

    public EmailSourceMessageListener(SourceEventListener sourceEventListener, String[] requiredProperties, String contentType) {
        this.sourceEventListener = sourceEventListener;
        this.requiredProperties = (String[])requiredProperties.clone();
        this.contentType = contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(EmailBaseMessage emailBaseMessage) {
        block6: {
            try {
                if (emailBaseMessage instanceof EmailTextMessage) {
                    String event = ((EmailTextMessage)emailBaseMessage).getText();
                    if (!event.isEmpty()) {
                        String[] transportProperties = this.getRequiredPropertyOrHeaderValues(emailBaseMessage);
                        this.sourceEventListener.onEvent((Object)event, transportProperties);
                    } else {
                        log.warn("Receive a message which satisfied the given criteria under the Search Term but in anothercontent type: " + emailBaseMessage.getHeader("Content-Type") + ". Therefore, skip themessage by further processing.");
                    }
                    break block6;
                }
                throw new SiddhiAppCreationException("Email source only support for the Text carbon message.");
            }
            finally {
                emailBaseMessage.sendAck();
            }
        }
    }

    private String[] getRequiredPropertyOrHeaderValues(EmailBaseMessage emailBaseMessage) {
        String[] values = new String[this.requiredProperties.length];
        int i = 0;
        for (String propertyKey : this.requiredProperties) {
            String headerValue = emailBaseMessage.getHeader(propertyKey);
            if (headerValue != null) {
                values[i++] = headerValue;
                continue;
            }
            Object propertyValue = emailBaseMessage.getProperty(propertyKey);
            if (propertyValue != null) {
                values[i++] = propertyValue.toString();
                continue;
            }
            log.error("Failed to find required transport property '" + propertyKey + "'.");
        }
        return values;
    }
}

