/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.email.server.connector;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.UIDFolder;
import org.wso2.transport.email.exception.EmailConnectorException;
import org.wso2.transport.email.utils.Constants;

public class ActionForProcessedMail {
    static void carryOutAction(Message message, Folder folder, Constants.ActionAfterProcessed action, Folder folderToMove) throws EmailConnectorException {
        Message[] messages = new Message[]{message};
        try {
            switch (action) {
                case MOVE: {
                    if (!folderToMove.isOpen()) {
                        folderToMove.open(2);
                    }
                    folder.copyMessages(messages, folderToMove);
                    message.setFlag(Flags.Flag.DELETED, true);
                    folder.expunge();
                    break;
                }
                case SEEN: {
                    message.setFlag(Flags.Flag.SEEN, true);
                    break;
                }
                case DELETE: {
                    message.setFlag(Flags.Flag.DELETED, true);
                    if (!(folder instanceof UIDFolder)) break;
                    folder.expunge();
                    break;
                }
                case FLAGGED: {
                    message.setFlag(Flags.Flag.FLAGGED, true);
                    break;
                }
                case ANSWERED: {
                    message.setFlag(Flags.Flag.ANSWERED, true);
                }
            }
        }
        catch (MessageRemovedException e) {
            throw new EmailConnectorException("Error is encountered while carrying out the action '" + (Object)((Object)action) + "'for processed mail since it has been deleted by another thread." + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new EmailConnectorException("Error is encountered while carrying out the action '" + (Object)((Object)action) + "'for processed mail." + e.getMessage(), e);
        }
    }
}

