/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.io.file.metrics.FileArchiveMetrics;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.log4j.Logger;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

@Extension(name="archive", namespace="file", description="Archives files and folders as a zip or in tar format that are available in the given file uri.\n", parameters={@Parameter(name="uri", description="Absolute path of the file or the directory", type={DataType.STRING}, dynamic=true), @Parameter(name="destination.dir.uri", description="Absolute directory path of the the archived file.", type={DataType.STRING}, dynamic=true), @Parameter(name="archive.type", description="Archive type can be zip or tar", type={DataType.STRING}, optional=true, defaultValue="zip"), @Parameter(name="include.by.regexp", description="Only the files matching the patterns will be archived.\nNote: Add an empty string to match all files", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>"), @Parameter(name="exclude.subdirectories", description="This flag is used to exclude the subdirectories and its files without archiving.", type={DataType.BOOL}, defaultValue="false", optional=true)}, parameterOverloads={@ParameterOverload(parameterNames={"uri", "destination.dir.uri"}), @ParameterOverload(parameterNames={"uri", "destination.dir.uri", "archive.type"}), @ParameterOverload(parameterNames={"uri", "destination.dir.uri", "archive.type", "include.by.regexp"}), @ParameterOverload(parameterNames={"uri", "destination.dir.uri", "archive.type", "include.by.regexp", "exclude.subdirectories"})}, examples={@Example(syntax="InputStream#file:archive('/User/wso2/to_be_archived', '/User/wso2/archive_destination/file.zip')", description="Archives to_be_archived folder in zip format and stores archive_destination folder as file.zip."), @Example(syntax="InputStream#file:archive('/User/wso2/to_be_archived', '/User/wso2/archive_destination/file', 'tar')", description="Archives to_be_archived folder in tar format and stores in archive_destination folder as file.tar."), @Example(syntax="InputStream#file:archive('/User/wso2/to_be_archived', '/User/wso2/archive_destination/file', 'tar', '.*test3.txt$')", description="Archives files which adheres to '.*test3.txt$' regex in to_be_archived folder in tar format and stores in archive_destination folder as file.tar."), @Example(syntax="InputStream#file:archive('/User/wso2/to_be_archived', '/User/wso2/archive_destination/file', '', '', 'false')", description="Archives to_be_archived folder excluding the sub-folders in zip format and stores in archive_destination folder as file.tar.")})
public class FileArchiveExtension
extends StreamFunctionProcessor {
    private static final Logger log = Logger.getLogger(FileArchiveExtension.class);
    private Pattern pattern = null;
    private int inputExecutorLength;
    private String siddhiAppName;
    private FileArchiveMetrics fileArchiveMetrics;

    protected StateFactory init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiQueryContext siddhiQueryContext) {
        this.inputExecutorLength = attributeExpressionExecutors.length;
        if (attributeExpressionExecutors.length >= 4 && attributeExpressionExecutors[3] instanceof ConstantExpressionExecutor) {
            this.pattern = Pattern.compile(((ConstantExpressionExecutor)attributeExpressionExecutors[3]).getValue().toString());
        }
        this.siddhiAppName = siddhiQueryContext.getSiddhiAppContext().getName();
        if (MetricsDataHolder.getInstance().getMetricService() != null && MetricsDataHolder.getInstance().getMetricManagementService().isEnabled()) {
            try {
                if (MetricsDataHolder.getInstance().getMetricManagementService().isReporterRunning("prometheus")) {
                    this.fileArchiveMetrics = new FileArchiveMetrics(this.siddhiAppName);
                }
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)"Prometheus reporter is not running. Hence file metrics will not be initialized.");
            }
        }
        return null;
    }

    public List<Attribute> getReturnAttributes() {
        return new ArrayList<Attribute>();
    }

    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }

    protected Object[] process(Object[] data) {
        String uri = (String)data[0];
        String destinationDirUri = (String)data[1];
        if (destinationDirUri.lastIndexOf(File.separator) != destinationDirUri.length() - 1) {
            destinationDirUri = destinationDirUri + File.separator;
        }
        boolean excludeSubdirectories = false;
        String regex = "";
        String archiveType = "zip";
        if (this.inputExecutorLength >= 3) {
            archiveType = (String)data[2];
        }
        if (this.inputExecutorLength >= 4) {
            regex = (String)data[3];
        }
        if (this.inputExecutorLength == 5) {
            excludeSubdirectories = (Boolean)data[4];
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(regex);
        }
        FileObject destinationDirUriObject = Utils.getFileObject(destinationDirUri);
        try {
            if (!destinationDirUriObject.exists() || !destinationDirUriObject.isFolder()) {
                destinationDirUriObject.createFolder();
            }
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when creating the subdirectories for the destination directory  " + destinationDirUriObject.getName().getPath(), (Throwable)e);
        }
        if (this.fileArchiveMetrics != null) {
            this.fileArchiveMetrics.setSource(Utils.getShortFilePath(uri));
            this.fileArchiveMetrics.setDestination(Utils.getShortFilePath(destinationDirUri));
            this.fileArchiveMetrics.setType(Utils.getShortFilePath(archiveType));
            this.fileArchiveMetrics.setTime(System.currentTimeMillis());
        }
        File sourceFile = new File(uri);
        String destinationFile = destinationDirUri + sourceFile.getName();
        if (archiveType.compareToIgnoreCase("zip") == 0) {
            ArrayList<String> fileList = new ArrayList<String>();
            this.generateFileList(uri, sourceFile, fileList, excludeSubdirectories);
            try {
                this.zip(uri, destinationFile, fileList);
            }
            catch (IOException e) {
                if (this.fileArchiveMetrics != null) {
                    this.fileArchiveMetrics.getArchiveMetric(0);
                }
                throw new SiddhiAppRuntimeException("IOException occurred when archiving  " + uri, (Throwable)e);
            }
        }
        try {
            if (archiveType.compareToIgnoreCase("tar") != 0) {
                throw new SiddhiAppRuntimeException("Unsupported archive type: " + archiveType);
            }
            this.addToTarArchiveCompression(FileArchiveExtension.getTarArchiveOutputStream(destinationFile), sourceFile, uri);
        }
        catch (IOException e) {
            if (this.fileArchiveMetrics != null) {
                this.fileArchiveMetrics.getArchiveMetric(0);
            }
            throw new SiddhiAppRuntimeException("Exception occurred when archiving " + uri, (Throwable)e);
        }
        if (this.fileArchiveMetrics != null) {
            this.fileArchiveMetrics.getArchiveMetric(1);
        }
        return new Object[0];
    }

    protected Object[] process(Object data) {
        return new Object[0];
    }

    public void start() {
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zip(String sourceFileUri, String zipFile, List<String> fileList) throws IOException {
        byte[] buffer = new byte[1024];
        FileInputStream in = null;
        ZipOutputStream zos = null;
        FileOutputStream fos = null;
        try {
            if (!zipFile.endsWith("zip")) {
                zipFile = zipFile.concat(".zip");
            }
            fos = new FileOutputStream(zipFile);
            zos = new ZipOutputStream(fos);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Output to Zip : " + zipFile + " started for folder/ file: " + sourceFileUri));
            }
            for (String file : fileList) {
                int len;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("File Adding : " + file + " to " + zipFile + "."));
                }
                ZipEntry ze = new ZipEntry(file);
                zos.putNextEntry(ze);
                in = new FileInputStream(sourceFileUri + File.separator + file);
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.closeEntry();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Output to Zip : " + zipFile + " is complete for folder/ file: " + sourceFileUri));
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)("IO exception occurred when closing zip input stream for file path: " + sourceFileUri));
                }
            }
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    log.error((Object)("IO exception occurred when closing zip output stream for file path: " + sourceFileUri));
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error((Object)("IO exception occurred when closing file output stream for file path: " + sourceFileUri));
                }
            }
        }
    }

    private void addToTarArchiveCompression(TarArchiveOutputStream out, File file, String sourceFileUri) throws IOException {
        if (file.isFile()) {
            String entryName = this.generateZipEntry(file.getAbsoluteFile().toString(), sourceFileUri);
            TarArchiveEntry entry = new TarArchiveEntry(file, entryName);
            out.putArchiveEntry(entry);
            FileInputStream fin = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fin);
            IOUtils.copy((InputStream)bis, (OutputStream)out);
            out.closeArchiveEntry();
        } else if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.addToTarArchiveCompression(out, child, sourceFileUri);
                }
            }
        } else {
            log.error((Object)(file.getName() + " is not supported for archiving. Archiving process continues.."));
        }
    }

    private static TarArchiveOutputStream getTarArchiveOutputStream(String name) throws IOException {
        if (!name.endsWith("tar")) {
            name = name.concat(".tar");
        }
        TarArchiveOutputStream taos = new TarArchiveOutputStream(new FileOutputStream(name));
        taos.setBigNumberMode(1);
        taos.setLongFileMode(2);
        taos.setAddPaxHeadersForNonAsciiNames(true);
        return taos;
    }

    private void generateFileList(String sourceFileUri, File node, List<String> fileList, boolean excludeSubdirectories) {
        String[] subNote;
        if (node.isFile() && this.pattern.matcher(node.getName()).lookingAt()) {
            fileList.add(this.generateZipEntry(node.getAbsoluteFile().toString(), sourceFileUri));
        }
        if (node.isDirectory() && !excludeSubdirectories && (subNote = node.list()) != null) {
            for (String filename : subNote) {
                this.generateFileList(sourceFileUri, new File(node, filename), fileList, false);
            }
        }
    }

    private String generateZipEntry(String file, String sourceFileUri) {
        return file.substring(sourceFileUri.length());
    }
}

