/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.log4j.Logger;

@Extension(name="create", namespace="file", description="Create a file or a folder in the given location", parameters={@Parameter(name="uri", description="Absolute file path which needs to be created.", type={DataType.STRING}, dynamic=true), @Parameter(name="is.directory", description="This flag is used when creating file path is a directory", type={DataType.STRING}, dynamic=true)}, examples={@Example(syntax="from CreateFileStream#file:create('/User/wso2/source/test.txt', false)", description="Creates a file in the given path with the name of 'test.txt'."), @Example(syntax="from CreateFileStream#file:create('/User/wso2/source/', true)", description="Creates a folder in the given path with the name of 'source'.")})
public class FileCreateExtension
extends StreamFunctionProcessor {
    private static final Logger log = Logger.getLogger(FileCreateExtension.class);

    protected StateFactory init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiQueryContext siddhiQueryContext) {
        return null;
    }

    public List<Attribute> getReturnAttributes() {
        return new ArrayList<Attribute>();
    }

    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }

    protected Object[] process(Object[] data) {
        String fileSourcePath = (String)data[0];
        boolean isDirectory = (Boolean)data[1];
        FileObject rootFileObject = Utils.getFileObject(fileSourcePath);
        try {
            if (isDirectory) {
                rootFileObject.createFolder();
            } else {
                rootFileObject.createFile();
            }
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Failure occurred when creating the file " + fileSourcePath, (Throwable)e);
        }
        return new Object[0];
    }

    protected Object[] process(Object data) {
        return new Object[0];
    }

    public void start() {
    }

    public void stop() {
    }
}

