/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.io.file.metrics.FileDeleteMetrics;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.log4j.Logger;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

@Extension(name="delete", namespace="file", description="Deletes file/files in a particular path", parameters={@Parameter(name="uri", description="Absolute path of the file or the directory to be deleted.", type={DataType.STRING}, dynamic=true)}, examples={@Example(syntax="from DeleteFileStream#file:delete('/User/wso2/source/test.txt')", description="Deletes the file in the given path. "), @Example(syntax="from DeleteFileStream#file:delete('/User/wso2/source/')", description="Deletes the folder in the given path. ")})
public class FileDeleteExtension
extends StreamFunctionProcessor {
    private static final Logger log = Logger.getLogger(FileDeleteExtension.class);
    private FileDeleteMetrics fileDeleteMetrics;

    protected StateFactory init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiQueryContext siddhiQueryContext) {
        if (MetricsDataHolder.getInstance().getMetricService() != null && MetricsDataHolder.getInstance().getMetricManagementService().isEnabled()) {
            try {
                if (MetricsDataHolder.getInstance().getMetricManagementService().isReporterRunning("prometheus")) {
                    String siddhiAppName = siddhiQueryContext.getSiddhiAppContext().getName();
                    this.fileDeleteMetrics = new FileDeleteMetrics(siddhiAppName);
                }
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)"Prometheus reporter is not running. Hence file metrics will not be initialized.");
            }
        }
        return null;
    }

    public List<Attribute> getReturnAttributes() {
        return new ArrayList<Attribute>();
    }

    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }

    protected Object[] process(Object[] data) {
        return new Object[0];
    }

    protected Object[] process(Object data) {
        String fileDeletePathUri = (String)data;
        if (this.fileDeleteMetrics != null) {
            this.fileDeleteMetrics.setSource(fileDeletePathUri);
            this.fileDeleteMetrics.setTime(System.currentTimeMillis());
        }
        try {
            FileObject rootFileObject = Utils.getFileObject(fileDeletePathUri);
            rootFileObject.delete(Selectors.SELECT_ALL);
            if (this.fileDeleteMetrics != null) {
                this.fileDeleteMetrics.getDeleteMetric(1);
            }
        }
        catch (FileSystemException e) {
            if (this.fileDeleteMetrics != null) {
                this.fileDeleteMetrics.getDeleteMetric(0);
            }
            throw new SiddhiAppRuntimeException("Failure occurred when deleting the file " + fileDeletePathUri, (Throwable)e);
        }
        return new Object[0];
    }

    public void start() {
    }

    public void stop() {
    }
}

