/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.Attribute;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.log4j.Logger;

@Extension(name="isExist", namespace="file", description="This function checks whether a file or a folder exists in a given path", parameters={@Parameter(name="uri", description="File path to check for existence.", type={DataType.STRING}, dynamic=true)}, returnAttributes={@ReturnAttribute(description="Value will be set to true if the path exists. False if otherwise.", type={DataType.BOOL})}, examples={@Example(syntax="file:isExist('/User/wso2/source/test.txt') as exists", description="Checks existence of a file in the given path. Result will be returned as an boolean ."), @Example(syntax="file:isExist('/User/wso2/source/') as exists", description="Checks existence of a folder in the given path. Result will be returned as an boolean .")})
public class FileExistsExtension
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(FileExistsExtension.class);
    private Attribute.Type returnType = Attribute.Type.BOOL;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        String fileExistPathUri = (String)data;
        try {
            return Utils.getFileObject((String)data).exists();
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when checking the existence of  " + fileExistPathUri, (Throwable)e);
        }
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

