/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.Attribute;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.log4j.Logger;

@Extension(name="isDirectory", namespace="file", description="This function checks for a given file path points to a directory", parameters={@Parameter(name="uri", description="The path to be checked for a directory.", type={DataType.STRING}, dynamic=true)}, returnAttributes={@ReturnAttribute(description="Value will be set to true if the directory exists in the given path. False if otherwise.", type={DataType.BOOL})}, examples={@Example(syntax="file:isDirectory(filePath) as isDirectory", description="Checks whether the given path is a directory. Result will be returned as an boolean.")})
public class FileIsDirectoryExtension
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(FileIsDirectoryExtension.class);
    private Attribute.Type returnType = Attribute.Type.BOOL;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        String filePathUri = (String)data;
        try {
            return Utils.getFileObject(filePathUri).isFolder();
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when checking type of file in path: " + filePathUri, (Throwable)e);
        }
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

