/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.execution.file.FileCopyExtension;
import io.siddhi.extension.io.file.metrics.FileMoveMetrics;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.log4j.Logger;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

@Extension(name="move", namespace="file", description="This function performs copying file from one directory to another.\n", parameters={@Parameter(name="uri", description="Absolute file or directory path.", type={DataType.STRING}, dynamic=true), @Parameter(name="destination.dir.uri", description="Absolute file path to the destination directory.\nNote: Parent folder structure will be created if it does not exist.", type={DataType.STRING}, dynamic=true), @Parameter(name="include.by.regexp", description="Only the files matching the patterns will be moved.\nNote: Add an empty string to match all files", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>"), @Parameter(name="exclude.root.dir", description="Exclude parent folder when moving the content.", type={DataType.BOOL}, optional=true, defaultValue="false")}, parameterOverloads={@ParameterOverload(parameterNames={"uri", "destination.dir.uri"}), @ParameterOverload(parameterNames={"uri", "destination.dir.uri", "include.by.regexp"}), @ParameterOverload(parameterNames={"uri", "destination.dir.uri", "include.by.regexp", "exclude.root.dir"})}, returnAttributes={@ReturnAttribute(name="isSuccess", description="Status of the file moving operation (true if success)", type={DataType.BOOL})}, examples={@Example(syntax="InputStream#file:move('/User/wso2/source/test.txt', 'User/wso2/destination/')", description="Moves 'test.txt' in 'source' folder to the 'destination' folder."), @Example(syntax="InputStream#file:move('/User/wso2/source/', 'User/wso2/destination/')", description="Moves 'source' folder to the 'destination' folder with all its content"), @Example(syntax="InputStream#file:move('/User/wso2/source/', 'User/wso2/destination/', '.*test3.txt$')", description="Moves 'source' folder to the 'destination' folder excluding files doesnt adhere to the given regex."), @Example(syntax="InputStream#file:move('/User/wso2/source/', 'User/wso2/destination/', '', true)", description="Moves only the files resides in 'source' folder to 'destination' folder.")})
public class FileMoveExtension
extends StreamFunctionProcessor {
    private static final Logger log = Logger.getLogger(FileCopyExtension.class);
    private Pattern pattern = null;
    private int inputExecutorLength;
    private FileMoveMetrics fileMoveMetrics;

    protected StateFactory init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiQueryContext siddhiQueryContext) {
        this.inputExecutorLength = attributeExpressionExecutors.length;
        if (attributeExpressionExecutors.length >= 3 && attributeExpressionExecutors[2] instanceof ConstantExpressionExecutor) {
            this.pattern = Pattern.compile(((ConstantExpressionExecutor)attributeExpressionExecutors[2]).getValue().toString());
        }
        if (MetricsDataHolder.getInstance().getMetricService() != null && MetricsDataHolder.getInstance().getMetricManagementService().isEnabled()) {
            try {
                if (MetricsDataHolder.getInstance().getMetricManagementService().isReporterRunning("prometheus")) {
                    String siddhiAppName = siddhiQueryContext.getSiddhiAppContext().getName();
                    this.fileMoveMetrics = new FileMoveMetrics(siddhiAppName);
                }
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)"Prometheus reporter is not running. Hence file metrics will not be initialized.");
            }
        }
        return null;
    }

    public List<Attribute> getReturnAttributes() {
        return new ArrayList<Attribute>();
    }

    public ProcessingMode getProcessingMode() {
        return ProcessingMode.BATCH;
    }

    protected Object[] process(Object[] data) {
        String uri = (String)data[0];
        String destinationDirUri = (String)data[1];
        String regex = "";
        boolean excludeParentFolder = false;
        if (this.inputExecutorLength == 3) {
            regex = (String)data[2];
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(regex);
        }
        try {
            FileObject rootFileObject = Utils.getFileObject(uri);
            if (rootFileObject.getType().hasContent() && this.pattern.matcher(rootFileObject.getName().getBaseName()).lookingAt()) {
                this.moveFileToDestination(rootFileObject, destinationDirUri, this.pattern);
            } else if (rootFileObject.getType().hasChildren()) {
                if (this.inputExecutorLength == 4) {
                    excludeParentFolder = (Boolean)data[3];
                }
                if (!excludeParentFolder) {
                    destinationDirUri = destinationDirUri.concat(File.separator + rootFileObject.getName().getBaseName());
                }
                ArrayList<FileObject> fileObjectList = new ArrayList<FileObject>();
                Utils.generateFileList(Utils.getFileObject(uri), fileObjectList, false);
                for (FileObject sourceFileObject : fileObjectList) {
                    if (!sourceFileObject.getType().hasContent() || !this.pattern.matcher(sourceFileObject.getName().getBaseName()).lookingAt()) continue;
                    String sourcePartialUri = sourceFileObject.getName().getPath();
                    sourcePartialUri = excludeParentFolder ? sourcePartialUri.replace(uri + rootFileObject.getName().getBaseName(), "") : sourcePartialUri.replace(uri, "").replace(sourceFileObject.getName().getBaseName(), "");
                    this.moveFileToDestination(sourceFileObject, destinationDirUri + sourcePartialUri, this.pattern);
                }
            }
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when getting the file type " + uri, (Throwable)e);
        }
        return new Object[0];
    }

    protected Object[] process(Object data) {
        return new Object[0];
    }

    public void start() {
    }

    public void stop() {
    }

    private void moveFileToDestination(FileObject sourceFileObject, String destinationDirUri, Pattern pattern) {
        try {
            String fileName = sourceFileObject.getName().getBaseName();
            if (sourceFileObject.isFile()) {
                String destinationPath = destinationDirUri + File.separator + sourceFileObject.getName().getBaseName();
                FileObject destinationFileObject = Utils.getFileObject(destinationPath);
                FileObject destinationFolderFileObject = Utils.getFileObject(destinationDirUri);
                if (!destinationFolderFileObject.exists()) {
                    destinationFolderFileObject.createFolder();
                }
                if (this.fileMoveMetrics != null) {
                    this.fileMoveMetrics.set_source(Utils.getShortFilePath(sourceFileObject.getName().getPath()));
                    this.fileMoveMetrics.setDestination(Utils.getShortFilePath(destinationDirUri));
                    this.fileMoveMetrics.setTime(System.currentTimeMillis());
                }
                if (pattern.matcher(fileName).lookingAt()) {
                    sourceFileObject.moveTo(destinationFileObject);
                }
                if (this.fileMoveMetrics != null) {
                    this.fileMoveMetrics.getMoveMetric(1);
                }
            }
        }
        catch (FileSystemException e) {
            if (this.fileMoveMetrics != null) {
                this.fileMoveMetrics.getMoveMetric(0);
            }
            throw new SiddhiAppRuntimeException("Exception occurred when doing file operations when moving for file: " + sourceFileObject.getName().getPath(), (Throwable)e);
        }
    }
}

