/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.file;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.util.Utils;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.log4j.Logger;

@Extension(name="size", namespace="file", description="This function checks for a given file's size", parameters={@Parameter(name="uri", description="Absolute path to the file or directory to be checked for the size.", type={DataType.STRING}, dynamic=true)}, returnAttributes={@ReturnAttribute(description="Size of the given file or the directory.", type={DataType.LONG})}, examples={@Example(syntax="file:size('/User/wso2/source/test.txt') as fileSize", description="Size of a file in a given path will be returned.")})
public class FileSizeExtension
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(FileSizeExtension.class);
    private Attribute.Type returnType = Attribute.Type.LONG;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        int executorsCount = attributeExpressionExecutors.length;
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to file:size() function, required 1, but found " + executorsCount);
        }
        ExpressionExecutor executor1 = attributeExpressionExecutors[0];
        if (executor1.getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the filePath (first argument) of file:size() function, required " + Attribute.Type.STRING.toString() + ", but found " + executor1.getReturnType().toString());
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        String sourceFileUri = (String)data;
        try {
            FileObject fileObj = Utils.getFileObject(sourceFileUri);
            if (fileObj.isFile()) {
                return fileObj.getContent().getSize();
            }
            return FileUtils.sizeOfDirectory((File)new File(sourceFileUri));
        }
        catch (FileSystemException e) {
            throw new SiddhiAppRuntimeException("Exception occurred when getting the file size of " + sourceFileUri, (Throwable)e);
        }
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

