/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.file;

import org.apache.log4j.Logger;
import org.wso2.transport.remotefilesystem.exception.RemoteFileSystemConnectorException;
import org.wso2.transport.remotefilesystem.server.connector.contract.RemoteFileSystemServerConnector;

public class FileSourcePoller
implements Runnable {
    private static final Logger log = Logger.getLogger(FileSourcePoller.class);
    private CompletionCallback completionCallback;
    private RemoteFileSystemServerConnector fileSystemServerConnector;
    private String siddhiAppName;

    public FileSourcePoller(RemoteFileSystemServerConnector fileSystemServerConnector, String siddhiAppName) {
        this.fileSystemServerConnector = fileSystemServerConnector;
        this.siddhiAppName = siddhiAppName;
    }

    public void setCompletionCallback(CompletionCallback completionCallback) {
        this.completionCallback = completionCallback;
    }

    @Override
    public void run() {
        try {
            this.fileSystemServerConnector.poll();
        }
        catch (RemoteFileSystemConnectorException e) {
            this.completionCallback.handle(e);
            log.error((Object)("Failed to connect to the remote file system server through the siddhi app '" + this.siddhiAppName + "'. "), (Throwable)e);
        }
        catch (Throwable t) {
            log.error((Object)("Exception occurred when processing '" + this.siddhiAppName + "'. "), t);
        }
    }

    public static interface CompletionCallback {
        public void handle(Throwable var1);
    }
}

