/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp.test;

import junit.framework.Test;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;

public class FtpProviderTestCase
extends AbstractProviderTestConfig
implements ProviderTestConfig {
    private static final String TEST_URI = "test.ftp.uri";

    public static Test suite() throws Exception {
        if (System.getProperty(TEST_URI) != null) {
            return new ProviderTestSuite(new FtpProviderTestCase());
        }
        return FtpProviderTestCase.notConfigured(FtpProviderTestCase.class);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("ftp", (FileProvider)new FtpFileProvider());
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = System.getProperty(TEST_URI);
        FileSystemOptions opts = new FileSystemOptions();
        FtpFileSystemConfigBuilder.getInstance().setPassiveMode(opts, true);
        return manager.resolveFile(uri, opts);
    }
}

