/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.mime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MimeAttributesMap
implements Map<String, Object> {
    private Log log = LogFactory.getLog(MimeAttributesMap.class);
    private static final String OBJECT_PREFIX = "obj.";
    private final Part part;
    private Map<String, Object> backingMap;
    private final Map<String, Method> mimeMessageGetters = new TreeMap<String, Method>();

    public MimeAttributesMap(Part part) {
        this.part = part;
        this.addMimeMessageMethod(part.getClass().getMethods());
        this.addMimeMessageMethod(part.getClass().getDeclaredMethods());
    }

    private void addMimeMessageMethod(Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length > 0) continue;
            if (method.getName().startsWith("get")) {
                this.mimeMessageGetters.put(method.getName().substring(3), method);
                continue;
            }
            if (!method.getName().startsWith("is")) continue;
            this.mimeMessageGetters.put(method.getName().substring(2), method);
        }
    }

    private Map<String, Object> getMap() {
        if (this.backingMap == null) {
            this.backingMap = this.createMap();
        }
        return this.backingMap;
    }

    private Map<String, Object> createMap() {
        Enumeration headers;
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        try {
            Enumeration allHeaders;
            headers = allHeaders = this.part.getAllHeaders();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            String headerName = header.getName();
            Object values = ret.get(headerName);
            if (values == null) {
                ret.put(headerName, header.getValue());
                continue;
            }
            if (values instanceof String) {
                ArrayList<String> newValues = new ArrayList<String>();
                newValues.add((String)values);
                newValues.add(header.getValue());
                ret.put(headerName, newValues);
                continue;
            }
            if (!(values instanceof List)) continue;
            List list = (List)values;
            list.add(header.getValue());
        }
        for (Map.Entry<String, Method> entry : this.mimeMessageGetters.entrySet()) {
            String name = entry.getKey();
            Method method = entry.getValue();
            try {
                Object value = method.invoke((Object)this.part, new Object[0]);
                ret.put(OBJECT_PREFIX + name, value);
            }
            catch (IllegalAccessException e) {
                this.log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (this.part instanceof MimeMessage) {
            Address[] address;
            MimeMessage message = (MimeMessage)this.part;
            try {
                address = message.getRecipients(MimeMessage.RecipientType.BCC);
                ret.put("obj.Recipients.BCC", address);
            }
            catch (MessagingException e) {
                this.log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            try {
                address = message.getRecipients(MimeMessage.RecipientType.CC);
                ret.put("obj.Recipients.CC", address);
            }
            catch (MessagingException e) {
                this.log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            try {
                address = message.getRecipients(MimeMessage.RecipientType.TO);
                ret.put("obj.Recipients.TO", address);
            }
            catch (MessagingException e) {
                this.log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            try {
                address = message.getRecipients((Message.RecipientType)MimeMessage.RecipientType.NEWSGROUPS);
                ret.put("obj.Recipients.NEWSGROUPS", address);
            }
            catch (MessagingException e) {
                this.log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().size() < 1;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.getMap().get(key);
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.getMap().keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.getMap().values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.getMap().entrySet());
    }
}

