/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram.test;

import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;
import org.apache.commons.vfs2.provider.ram.RamFileSystemConfigBuilder;

public class CustomRamProviderTest
extends TestCase {
    DefaultFileSystemManager manager;
    FileSystemOptions zeroSized = new FileSystemOptions();
    FileSystemOptions smallSized = new FileSystemOptions();
    FileSystemOptions defaultRamFs = new FileSystemOptions();

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = new DefaultFileSystemManager();
        this.manager.addProvider("ram", (FileProvider)new RamFileProvider());
        this.manager.init();
        RamFileSystemConfigBuilder.getInstance().setMaxSize(this.zeroSized, 0);
        RamFileSystemConfigBuilder.getInstance().setMaxSize(this.smallSized, 10);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.manager.close();
    }

    public void testSmallFS() throws Exception {
        OutputStream os;
        FileObject fo1 = this.manager.resolveFile("ram:/");
        FileObject fo2 = this.manager.resolveFile("ram:/");
        CustomRamProviderTest.assertTrue((String)"Both files should exist in the same fs instance.", (fo1.getFileSystem() == fo2.getFileSystem() ? 1 : 0) != 0);
        FileObject fo3 = this.manager.resolveFile("ram:/fo3", this.smallSized);
        FileObject fo4 = this.manager.resolveFile("ram:/", this.smallSized);
        CustomRamProviderTest.assertTrue((String)"Both files should exist in different fs instances.", (fo3.getFileSystem() == fo4.getFileSystem() ? 1 : 0) != 0);
        CustomRamProviderTest.assertTrue((String)"These file shouldn't be in the same file system.", (fo1.getFileSystem() != fo3.getFileSystem() ? 1 : 0) != 0);
        fo3.createFile();
        try {
            os = fo3.getContent().getOutputStream();
            os.write(new byte[10]);
            os.close();
        }
        catch (FileSystemException e) {
            CustomRamProviderTest.fail((String)"It shouldn't save such a small file");
        }
        try {
            os = fo3.getContent().getOutputStream();
            os.write(new byte[11]);
            os.close();
            CustomRamProviderTest.fail((String)"It shouldn't save such a big file");
        }
        catch (FileSystemException e) {
            // empty catch block
        }
    }

    public void testRootFolderExists() throws FileSystemException {
        FileObject root = this.manager.resolveFile("ram:///", this.defaultRamFs);
        CustomRamProviderTest.assertTrue((boolean)root.getType().hasChildren());
        try {
            root.delete();
            CustomRamProviderTest.fail();
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }
}

